/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.android.gms.common.GoogleApiAvailability;
import com.yifants.sdk.purchase.GooglePurchase;
import com.yifants.sdk.purchase.d.a;
import com.yifants.sdk.purchase.d.c;
import com.yifants.sdk.purchase.d.d;
import com.yifants.sdk.purchase.d.e;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleBillingUtil {
    private final String c = "SDK_YiFans_Billing";
    boolean a = false;
    private final String d = "1.3.2";
    private String[] e = new String[0];
    private String[] f = new String[0];
    public List<SkuDetails> b = null;
    private BillingClient g;
    private BillingClient.Builder h;
    private OnPurchaseFinishedListener i;
    private OnStartSetupFinishedListener j;
    private OnQueryUnConsumeOrderListener k;
    private OnQueryHistoryQurchaseListener l;
    private OnQueryFinishedListener m;
    private OnConsumeFinishedListener n;
    private boolean o = false;
    private static final GoogleBillingUtil p = new GoogleBillingUtil();

    private GoogleBillingUtil() {
    }

    public static GoogleBillingUtil getInstance() {
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleBillingUtil build(Context context) {
        GoogleBillingUtil googleBillingUtil;
        this.e("SDK Version: 1.3.2");
        if (this.g == null) {
            googleBillingUtil = p;
            synchronized (googleBillingUtil) {
                if (this.g == null) {
                    if (GoogleBillingUtil.isGooglePlayServicesAvailable(context)) {
                        this.h = BillingClient.newBuilder((Context)context);
                        GoogleBillingUtil googleBillingUtil2 = p;
                        googleBillingUtil2.getClass();
                        this.g = this.h.setListener((PurchasesUpdatedListener)googleBillingUtil2.new MyPurchasesUpdatedListener()).build();
                    } else {
                        if (this.a) {
                            this.e("\u8b66\u544a:GooglePlay\u670d\u52a1\u5904\u4e8e\u4e0d\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5");
                        }
                        if (this.j != null) {
                            this.j.onSetupError();
                        }
                    }
                } else {
                    GoogleBillingUtil googleBillingUtil3 = p;
                    googleBillingUtil3.getClass();
                    this.h.setListener((PurchasesUpdatedListener)googleBillingUtil3.new MyPurchasesUpdatedListener());
                }
            }
        } else {
            GoogleBillingUtil googleBillingUtil4 = p;
            googleBillingUtil4.getClass();
            this.h.setListener((PurchasesUpdatedListener)googleBillingUtil4.new MyPurchasesUpdatedListener());
        }
        googleBillingUtil = p;
        synchronized (googleBillingUtil) {
            if (p.a()) {
                p.queryInventoryInApp();
                p.queryInventorySubs();
                p.queryPurchasesInApp();
            }
        }
        return p;
    }

    public String getVersion() {
        return "1.3.2";
    }

    public boolean a() {
        if (this.g == null) {
            this.e("\u521d\u59cb\u5316\u5931\u8d25:mBillingClient==null");
            return false;
        }
        if (!this.g.isReady()) {
            this.g.startConnection(new BillingClientStateListener(){

                public void onBillingSetupFinished(int n) {
                    if (n == 0) {
                        GoogleBillingUtil.this.queryInventoryInApp();
                        GoogleBillingUtil.this.queryInventorySubs();
                        GoogleBillingUtil.this.queryPurchasesInApp();
                        if (GoogleBillingUtil.this.j != null) {
                            GoogleBillingUtil.this.j.onSetupSuccess();
                        }
                    } else {
                        GoogleBillingUtil.this.e("\u521d\u59cb\u5316\u5931\u8d25:onSetupFail:code=" + n);
                        if (GoogleBillingUtil.this.j != null) {
                            GoogleBillingUtil.this.j.onSetupFail(n);
                        }
                    }
                }

                public void onBillingServiceDisconnected() {
                    if (GoogleBillingUtil.this.j != null) {
                        GoogleBillingUtil.this.j.onSetupError();
                    }
                    GoogleBillingUtil.this.e("\u521d\u59cb\u5316\u5931\u8d25:onBillingServiceDisconnected");
                }
            });
            return false;
        }
        return true;
    }

    public void queryInventoryInApp() {
        this.a("inapp");
    }

    public void queryInventorySubs() {
        this.a("subs");
    }

    private void a(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (GoogleBillingUtil.this.g == null) {
                    if (GoogleBillingUtil.this.m != null) {
                        GoogleBillingUtil.this.m.onQueryError();
                    }
                    return;
                }
                ArrayList arrayList = new ArrayList();
                if (string.equals("inapp")) {
                    Collections.addAll(arrayList, GoogleBillingUtil.this.e);
                } else if (string.equals("subs")) {
                    Collections.addAll(arrayList, GoogleBillingUtil.this.f);
                }
                SkuDetailsParams.Builder builder = SkuDetailsParams.newBuilder();
                builder.setSkusList(arrayList).setType(string);
                GoogleBillingUtil.this.g.querySkuDetailsAsync(builder.build(), (SkuDetailsResponseListener)new MySkuDetailsResponseListener(GoogleBillingUtil.this.m, string));
            }
        };
        this.a(runnable);
    }

    public void purchaseInApp(Activity activity, String string) {
        this.a(activity, string, "inapp");
    }

    public void purchaseSubs(Activity activity, String string) {
        this.a(activity, string, "subs");
    }

    private void a(Activity activity, String string, String string2) {
        if (this.g == null) {
            if (this.i != null) {
                this.i.onPurchaseError();
            }
            return;
        }
        if (this.a()) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("productId", (Object)string);
                jSONObject.put("type", (Object)string2);
                SkuDetails skuDetails = new SkuDetails(jSONObject.toString());
                BillingFlowParams billingFlowParams = BillingFlowParams.newBuilder().setSkuDetails(skuDetails).build();
                this.g.launchBillingFlow(activity, billingFlowParams);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        } else if (this.i != null) {
            this.i.onPurchaseError();
        }
    }

    public void consumeAsync(String string) {
        if (this.g == null) {
            return;
        }
        this.g.consumeAsync(string, (ConsumeResponseListener)new MyConsumeResponseListener());
    }

    public List<Purchase> queryPurchasesInApp() {
        return this.b("inapp");
    }

    public List<Purchase> queryPurchasesSubs() {
        return this.b("subs");
    }

    private List<Purchase> b(String string) {
        this.e("[queryPurchases] " + string);
        if (this.g == null) {
            return null;
        }
        if (!this.g.isReady()) {
            this.a();
        } else {
            Purchase.PurchasesResult purchasesResult = this.g.queryPurchases(string);
            if (purchasesResult != null && purchasesResult.getResponseCode() == 0) {
                List list = purchasesResult.getPurchasesList();
                if (list != null) {
                    this.e("[queryPurchases] size= " + list.size());
                    for (Purchase purchase : list) {
                        this.e(purchase.toString());
                        if (!string.equals("inapp") || !this.o) continue;
                        this.consumeAsync(purchase.getPurchaseToken());
                    }
                } else {
                    this.e("[queryPurchases] is null");
                }
                return list;
            }
        }
        return null;
    }

    public void queryHistoryInApp() {
        this.c("inapp");
    }

    public void queryHistorySubs() {
        this.c("subs");
    }

    private void c(final String string) {
        this.e("[queryPurchaseHistoryAsync] " + string);
        if (this.g == null) {
            return;
        }
        if (!this.g.isReady()) {
            this.a();
        } else {
            this.g.queryPurchaseHistoryAsync(string, new PurchaseHistoryResponseListener(){

                public void onPurchaseHistoryResponse(int n, List<Purchase> list) {
                    if (list != null && !list.isEmpty()) {
                        for (Purchase purchase : list) {
                            GoogleBillingUtil.this.e("[queryPurchaseHistoryAsync] OrderId: " + purchase.getOrderId() + "\nPackageName:" + purchase.getPackageName() + "\nPurchaseTime:" + purchase.getPurchaseTime() + "\nPurchaseToken:" + purchase.getPurchaseToken() + "\nSku:" + purchase.getSku());
                        }
                    }
                    if (GoogleBillingUtil.this.l != null) {
                        GoogleBillingUtil.this.l.onPurchaseHistoryResponse(string, n, list);
                    }
                }
            });
        }
    }

    public int getPurchasesSizeSubs() {
        List<Purchase> list = this.queryPurchasesSubs();
        if (list != null) {
            return list.size();
        }
        return -1;
    }

    public int getSubsPositionBySku(String string) {
        return this.a(string, "subs");
    }

    public int getInAppPositionBySku(String string) {
        return this.a(string, "inapp");
    }

    private int a(String string, String string2) {
        block5: {
            block4: {
                if (!string2.equals("inapp")) break block4;
                int n = 0;
                for (String string3 : this.e) {
                    if (string3.equals(string)) {
                        return n;
                    }
                    ++n;
                }
                break block5;
            }
            if (!string2.equals("subs")) break block5;
            int n = 0;
            for (String string4 : this.f) {
                if (string4.equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private void a(Runnable runnable) {
        if (this.a()) {
            runnable.run();
        }
    }

    public String getSubsSkuByPosition(int n) {
        if (n >= 0 && n < this.f.length) {
            return this.f[n];
        }
        return null;
    }

    public String getInAppSkuByPosition(int n) {
        if (n >= 0 && n < this.e.length) {
            return this.e[n];
        }
        return null;
    }

    private String d(String string) {
        if (Arrays.asList(this.e).contains(string)) {
            return "inapp";
        }
        if (Arrays.asList(this.f).contains(string)) {
            return "subs";
        }
        return null;
    }

    public SkuDetails getSkuDetail(String string) {
        if (this.b == null) {
            return null;
        }
        for (SkuDetails skuDetails : this.b) {
            if (!string.equals(skuDetails.getSku())) continue;
            return skuDetails;
        }
        return null;
    }

    public void queryUnConsumeOrders(Context context) {
        block2: {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("packageName", (Object)context.getPackageName());
                jSONObject.put("platform", (Object)com.yifants.sdk.purchase.a.a.a);
                jSONObject.put("gaid", (Object)com.yifants.sdk.purchase.a.a.f);
                String string = jSONObject.toString();
                this.e("queryUnConsumeOrders request: " + string);
                string = com.yifants.sdk.purchase.c.a.a(string);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("sign", (Object)string);
                com.yifants.sdk.purchase.d.c.a(com.yifants.sdk.purchase.c.a.b(com.yifants.sdk.purchase.a.a.i), jSONObject2.toString(), new a(){

                    @Override
                    public void onResponse(e e2) {
                        block9: {
                            try {
                                String string = new String(e2.c, "utf-8");
                                string = com.yifants.sdk.purchase.c.a.b(string);
                                JSONObject jSONObject = new JSONObject(string);
                                int n = jSONObject.optInt("code");
                                if (n == 200) {
                                    JSONArray jSONArray = jSONObject.optJSONArray("data");
                                    if (jSONArray != null && jSONArray.length() > 0) {
                                        ArrayList<GooglePurchase> arrayList = new ArrayList<GooglePurchase>(jSONArray.length());
                                        for (int i = 0; i < jSONArray.length(); ++i) {
                                            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                                            if (jSONObject2 == null) continue;
                                            GooglePurchase googlePurchase = new GooglePurchase();
                                            arrayList.add(googlePurchase);
                                            googlePurchase.orderId = jSONObject2.optString("orderId");
                                            googlePurchase.productId = jSONObject2.optString("productId");
                                            googlePurchase.purchaseTime = jSONObject2.optLong("purchaseTimeMillis");
                                            googlePurchase.purchaseToken = jSONObject2.optString("purchaseToken");
                                            googlePurchase.billingResponse = jSONObject2.optInt("billingResponse", 0);
                                            googlePurchase.purchaseState = jSONObject2.optInt("purchaseState", 0);
                                            googlePurchase.consumptionState = jSONObject2.optInt("consumptionState", 0);
                                        }
                                        if (GoogleBillingUtil.this.k != null) {
                                            GoogleBillingUtil.this.k.onQueryUnConsumeSuccess(n, arrayList);
                                        }
                                        return;
                                    }
                                    if (GoogleBillingUtil.this.k != null) {
                                        GoogleBillingUtil.this.k.onQueryUnConsumeSuccess(n, null);
                                    }
                                } else if (GoogleBillingUtil.this.k != null) {
                                    GoogleBillingUtil.this.k.onQueryUnConsumeFail(n, jSONObject.optString("msg"));
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (GoogleBillingUtil.this.k == null) break block9;
                                GoogleBillingUtil.this.k.onQueryUnConsumeFail(203, "response data error");
                            }
                        }
                    }

                    @Override
                    public void onFailure(d d2, IOException iOException) {
                        GoogleBillingUtil.this.e("[onFailure]: " + iOException.getMessage());
                        if (GoogleBillingUtil.this.k != null) {
                            GoogleBillingUtil.this.k.onQueryUnConsumeFail(204, iOException.getMessage());
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.k == null) break block2;
                this.k.onQueryUnConsumeFail(205, "request failed");
            }
        }
    }

    public static boolean isGooglePlayServicesAvailable(Context context) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        if (googleApiAvailability != null) {
            int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
            return n == 0;
        }
        return false;
    }

    public GoogleBillingUtil setOnQueryFinishedListener(OnQueryFinishedListener onQueryFinishedListener) {
        this.m = onQueryFinishedListener;
        return p;
    }

    public GoogleBillingUtil setOnPurchaseFinishedListener(OnPurchaseFinishedListener onPurchaseFinishedListener) {
        this.i = onPurchaseFinishedListener;
        return p;
    }

    public GoogleBillingUtil setOnConsumeFinishedListener(OnConsumeFinishedListener onConsumeFinishedListener) {
        this.n = onConsumeFinishedListener;
        return p;
    }

    public GoogleBillingUtil setOnStartSetupFinishedListener(OnStartSetupFinishedListener onStartSetupFinishedListener) {
        this.j = onStartSetupFinishedListener;
        return p;
    }

    public GoogleBillingUtil setOnQueryUnConsumeOrderListener(OnQueryUnConsumeOrderListener onQueryUnConsumeOrderListener) {
        this.k = onQueryUnConsumeOrderListener;
        return p;
    }

    public GoogleBillingUtil setOnQueryHistoryQurchaseListener(OnQueryHistoryQurchaseListener onQueryHistoryQurchaseListener) {
        this.l = onQueryHistoryQurchaseListener;
        return p;
    }

    public GoogleBillingUtil setDebugAble(boolean bl) {
        this.a = bl;
        return p;
    }

    public GoogleBillingUtil setInAppSKUS(String[] stringArray) {
        this.e = stringArray;
        return p;
    }

    public GoogleBillingUtil setSubsSKUS(String[] stringArray) {
        this.f = stringArray;
        return p;
    }

    public GoogleBillingUtil setAutoConsumeAsync(boolean bl) {
        this.o = bl;
        return p;
    }

    public boolean isReady() {
        return this.g != null && this.g.isReady();
    }

    public boolean isAutoConsumeAsync() {
        return this.o;
    }

    public void setIsAutoConsumeAsync(boolean bl) {
        this.o = bl;
    }

    private void e(String string) {
        if (this.a) {
            Log.i((String)"SDK_YiFans_Billing", (String)string);
        }
    }

    public static interface OnStartSetupFinishedListener {
        public void onSetupSuccess();

        public void onSetupFail(int var1);

        public void onSetupError();
    }

    public static interface OnQueryHistoryQurchaseListener {
        public void onPurchaseHistoryResponse(String var1, int var2, List<Purchase> var3);
    }

    public static interface OnQueryUnConsumeOrderListener {
        public void onQueryUnConsumeSuccess(int var1, List<GooglePurchase> var2);

        public void onQueryUnConsumeFail(int var1, String var2);
    }

    public static interface OnConsumeFinishedListener {
        public void onConsumeSuccess(String var1);

        public void onConsumeFail(int var1, String var2);
    }

    public static interface OnPurchaseFinishedListener {
        public void onPurchaseSuccess(int var1, List<Purchase> var2);

        public void onPurchaseFail(int var1, List<Purchase> var2);

        public void onPurchaseError();
    }

    public static interface OnQueryFinishedListener {
        public void onQuerySuccess(String var1, List<SkuDetails> var2);

        public void onQueryFail(int var1, String var2, List<SkuDetails> var3);

        public void onQueryError();
    }

    private class MyConsumeResponseListener
    implements ConsumeResponseListener {
        private MyConsumeResponseListener() {
        }

        public void onConsumeResponse(int n, String string) {
            if (GoogleBillingUtil.this.n == null) {
                if (GoogleBillingUtil.this.a) {
                    GoogleBillingUtil.this.e("\u8b66\u544a:\u63a5\u6536\u5230\u6d88\u8017\u5546\u54c1\u56de\u8c03\uff0c\u4f46\u6d88\u8017\u5546\u54c1\u63a5\u53e3\u4e3aNull\uff0c\u8bf7\u8bbe\u7f6e\u6d88\u8017\u5546\u54c1\u56de\u8c03\u63a5\u53e3\u3002eg:setOnConsumeFinishedListener()");
                }
                return;
            }
            if (n == 0) {
                GoogleBillingUtil.this.n.onConsumeSuccess(string);
            } else {
                GoogleBillingUtil.this.n.onConsumeFail(n, string);
            }
        }
    }

    private class MySkuDetailsResponseListener
    implements SkuDetailsResponseListener {
        private OnQueryFinishedListener mOnQueryFinishedListener;
        private String skuType;

        public MySkuDetailsResponseListener(OnQueryFinishedListener onQueryFinishedListener, String string) {
            this.mOnQueryFinishedListener = onQueryFinishedListener;
            this.skuType = string;
        }

        public void onSkuDetailsResponse(int n, List<SkuDetails> list) {
            if (this.mOnQueryFinishedListener == null) {
                if (GoogleBillingUtil.this.a) {
                    GoogleBillingUtil.this.e("\u8b66\u544a:\u63a5\u6536\u5230\u67e5\u8be2\u5546\u54c1\u56de\u8c03\uff0c\u4f46\u67e5\u8be2\u5546\u54c1\u63a5\u53e3\u4e3aNull\uff0c\u8bf7\u8bbe\u7f6e\u8d2d\u4e70\u63a5\u53e3\u3002eg:setOnQueryFinishedListener()");
                }
                return;
            }
            if (n == 0 && list != null) {
                this.mOnQueryFinishedListener.onQuerySuccess(this.skuType, list);
                GoogleBillingUtil.this.b = new ArrayList<SkuDetails>(list.size());
                GoogleBillingUtil.this.b.addAll(list);
            } else {
                this.mOnQueryFinishedListener.onQueryFail(n, this.skuType, list);
            }
        }
    }

    private class MyPurchasesUpdatedListener
    implements PurchasesUpdatedListener {
        private MyPurchasesUpdatedListener() {
        }

        public void onPurchasesUpdated(int n, List<Purchase> list) {
            if (GoogleBillingUtil.this.i == null) {
                if (GoogleBillingUtil.this.a) {
                    GoogleBillingUtil.this.e("\u8b66\u544a:\u63a5\u6536\u5230\u8d2d\u4e70\u56de\u8c03\uff0c\u4f46\u8d2d\u4e70\u5546\u54c1\u63a5\u53e3\u4e3aNull\uff0c\u8bf7\u8bbe\u7f6e\u8d2d\u4e70\u63a5\u53e3\u3002eg:setOnPurchaseFinishedListener()");
                }
                return;
            }
            if (n == 0 && list != null) {
                if (GoogleBillingUtil.this.o) {
                    for (Purchase purchase : list) {
                        String string;
                        String string2 = purchase.getSku();
                        if (string2 == null || (string = GoogleBillingUtil.this.d(string2)) == null || !string.equals("inapp")) continue;
                        GoogleBillingUtil.this.consumeAsync(purchase.getPurchaseToken());
                    }
                }
                GoogleBillingUtil.this.i.onPurchaseSuccess(n, list);
            } else {
                GoogleBillingUtil.this.i.onPurchaseFail(n, list);
            }
        }
    }
}

