/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.SkuDetails;
import com.yifants.sdk.purchase.GoogleBillingUtil;
import com.yifants.sdk.purchase.GooglePurchase;
import com.yifants.sdk.purchase.d.a;
import com.yifants.sdk.purchase.d.c;
import com.yifants.sdk.purchase.d.d;
import com.yifants.sdk.purchase.d.e;
import com.yifants.sdk.purchase.e.a;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public class VerifyPurchaseUtil {
    private final String a = "SDK_YiFans_Verify";
    private static final VerifyPurchaseUtil b = new VerifyPurchaseUtil();
    private SimpleDateFormat c = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'Z");
    private int d = 10000;
    private String e = "s30cGbimxIYtVvsx";
    private static ArrayList<GooglePurchase> f = null;
    private static OnVerifyPurchaseListener g = null;
    private boolean h = false;
    private boolean i = false;
    private Handler j = new Handler(){

        public void handleMessage(Message message) {
            super.handleMessage(message);
            VerifyPurchaseUtil.this.a("[handleMessage] to checkOrder -->");
            VerifyPurchaseUtil.this.b();
        }
    };

    private VerifyPurchaseUtil() {
    }

    public static VerifyPurchaseUtil getInstance() {
        return b;
    }

    public VerifyPurchaseUtil build(Context context) {
        this.a(context);
        this.h = true;
        return b;
    }

    private void a(Context context) {
        com.yifants.sdk.purchase.a.a.a = "1";
        com.yifants.sdk.purchase.a.a.c = Locale.getDefault().getLanguage();
        com.yifants.sdk.purchase.a.a.d = Locale.getDefault().getCountry();
        com.yifants.sdk.purchase.a.a.b = Build.VERSION.RELEASE;
        com.yifants.sdk.purchase.a.a.e = Build.MODEL;
        com.yifants.sdk.purchase.a.a.g = context.getPackageName();
        com.yifants.sdk.purchase.e.a.a(context, new a.a(){

            @Override
            public void onPlayAdIdRead(String string) {
                com.yifants.sdk.purchase.a.a.f = string;
            }
        });
    }

    public VerifyPurchaseUtil setOnVerifyPurchaseListener(OnVerifyPurchaseListener onVerifyPurchaseListener) {
        g = onVerifyPurchaseListener;
        return b;
    }

    public VerifyPurchaseUtil setMaxVerifyTime(int n) {
        if (n >= 0) {
            this.d = n * 1000;
        }
        return b;
    }

    public void verifyPurchase(int n, List<Purchase> list) {
        this.a("[verifyPurchase] purchaseCode: " + n);
        if (list == null || list.isEmpty()) {
            this.a("[verifyPurchase] Purchase list is empty, return");
            return;
        }
        if (f == null || f.size() == 0) {
            f = new ArrayList();
        }
        for (Purchase purchase : list) {
            GooglePurchase googlePurchase = new GooglePurchase();
            googlePurchase.orderId = purchase.getOrderId();
            googlePurchase.packageName = !TextUtils.isEmpty((CharSequence)purchase.getPackageName()) ? purchase.getPackageName() : com.yifants.sdk.purchase.a.a.g;
            googlePurchase.purchaseTime = purchase.getPurchaseTime();
            googlePurchase.purchaseToken = purchase.getPurchaseToken();
            googlePurchase.productId = purchase.getSku();
            googlePurchase.billingResponse = n;
            googlePurchase.localTime = this.c.format(new Date());
            boolean bl = GoogleBillingUtil.getInstance().isAutoConsumeAsync();
            googlePurchase.consumptionState = bl ? 1 : 0;
            f.add(googlePurchase);
            this.a(googlePurchase);
        }
    }

    private void a(final GooglePurchase googlePurchase) {
        if (googlePurchase == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("orderId", (Object)googlePurchase.orderId);
            jSONObject.put("packageName", (Object)googlePurchase.packageName);
            jSONObject.put("purchaseTime", googlePurchase.purchaseTime);
            jSONObject.put("purchaseToken", (Object)googlePurchase.purchaseToken);
            jSONObject.put("productId", (Object)googlePurchase.productId);
            jSONObject.put("billingResponse", googlePurchase.billingResponse);
            jSONObject.put("localTime", (Object)googlePurchase.localTime);
            SkuDetails skuDetails = GoogleBillingUtil.getInstance().getSkuDetail(googlePurchase.productId);
            if (skuDetails != null) {
                jSONObject.put("price", (Object)skuDetails.getPrice());
                jSONObject.put("priceCurrencyCode", (Object)skuDetails.getPriceCurrencyCode());
            } else {
                if (GoogleBillingUtil.getInstance().b == null || GoogleBillingUtil.getInstance().b.size() == 0) {
                    if (GoogleBillingUtil.getInstance().a()) {
                        GoogleBillingUtil.getInstance().queryInventoryInApp();
                        GoogleBillingUtil.getInstance().queryInventorySubs();
                    }
                    this.a("[send] skuDetail is null, will try to get skuDetail of this order[" + googlePurchase.purchaseToken + "] - sku[" + googlePurchase.productId + "] again");
                    this.a(googlePurchase.purchaseToken, 100, -1);
                    return;
                }
                this.a("[send] can not find the skuDetail of this order[" + googlePurchase.purchaseToken + "] - sku[" + googlePurchase.productId + "]");
            }
            jSONObject.put("platform", (Object)com.yifants.sdk.purchase.a.a.a);
            jSONObject.put("gaid", (Object)com.yifants.sdk.purchase.a.a.f);
            jSONObject.put("osv", (Object)com.yifants.sdk.purchase.a.a.b);
            jSONObject.put("model", (Object)com.yifants.sdk.purchase.a.a.e);
            jSONObject.put("language", (Object)com.yifants.sdk.purchase.a.a.c);
            jSONObject.put("country", (Object)com.yifants.sdk.purchase.a.a.d);
            String string = jSONObject.toString();
            this.a("send request: " + string);
            string = com.yifants.sdk.purchase.c.a.a(string);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("sign", (Object)string);
            this.a("[send] orderId==>" + googlePurchase.orderId);
            com.yifants.sdk.purchase.d.c.a(com.yifants.sdk.purchase.c.a.b(com.yifants.sdk.purchase.a.a.h), jSONObject2.toString(), new a(){

                @Override
                public void onResponse(e e2) {
                    block5: {
                        try {
                            String string = new String(e2.c, "utf-8");
                            string = com.yifants.sdk.purchase.c.a.b(string);
                            VerifyPurchaseUtil.this.a("[send] respContent==>" + string);
                            JSONObject jSONObject = new JSONObject(string);
                            int n = jSONObject.optInt("code");
                            String string2 = googlePurchase.orderId;
                            String string3 = googlePurchase.purchaseToken;
                            VerifyPurchaseUtil.this.a("[onResponse] before orderId==>" + string2 + " , state==>" + n + ", purchaseToken==>" + string3);
                            int n2 = -1;
                            if (n == 200) {
                                JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                                if (jSONObject2 != null) {
                                    string2 = jSONObject2.optString("orderId", string2);
                                    string3 = jSONObject2.optString("purchaseToken", string3);
                                    n2 = jSONObject2.optInt("purchaseState");
                                    boolean bl = GoogleBillingUtil.getInstance().isAutoConsumeAsync();
                                    googlePurchase.consumptionState = jSONObject2.optInt("consumptionState", bl ? 1 : 0);
                                }
                            } else {
                                String string4 = jSONObject.optString("msg");
                                VerifyPurchaseUtil.this.a("[onResponse] code==>" + n + " , msg==>" + string4 + ", next will check order again with google");
                            }
                            VerifyPurchaseUtil.this.a("[onResponse] after orderId==>" + string2 + " , state==>" + n + ", purchaseToken==>" + string3);
                            VerifyPurchaseUtil.this.a(string3, n, n2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            if (g == null) break block5;
                            g.onVerifyError(203, googlePurchase);
                        }
                    }
                }

                @Override
                public void onFailure(d d2, IOException iOException) {
                    VerifyPurchaseUtil.this.a("[onFailure]: " + iOException.getMessage());
                    if (g != null) {
                        g.onVerifyError(204, googlePurchase);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a(String string, int n, int n2) {
        this.a("[updateOrderState] purchaseToken: " + string + "; responseState: " + n + "; purchaseState: " + n2);
        if (f == null) {
            this.a("[updateOrderState] orders == null");
            return;
        }
        for (GooglePurchase googlePurchase : f) {
            boolean bl;
            if (googlePurchase.billingResponse != 0 || !string.equals(googlePurchase.purchaseToken)) continue;
            googlePurchase.state = n;
            boolean bl2 = bl = googlePurchase.purchaseState == -1;
            if (bl) {
                googlePurchase.purchaseState = n2;
            }
            googlePurchase.resultTime = System.currentTimeMillis();
            if (googlePurchase.state == 200) {
                if (bl && g != null) {
                    if (n2 == 0) {
                        this.a("[updateOrderState] onVerifyFinish - " + googlePurchase.orderId);
                        g.onVerifyFinish(googlePurchase);
                        continue;
                    }
                    this.a("[updateOrderState] onVerifyError - " + googlePurchase.orderId);
                    g.onVerifyError(googlePurchase.state, googlePurchase);
                    continue;
                }
                this.a("[updateOrderState] hasNotChecked: " + bl + " or mOnVerifyPurchaseListener == null");
                continue;
            }
            if (googlePurchase.state == 100) {
                boolean bl3 = this.b(googlePurchase);
                this.a("[updateOrderState] hasNotChecked: " + bl + "; maxVerifyTime= " + this.d + "; isNotMax= " + bl3);
                if (!bl) continue;
                if (bl3) {
                    this.c();
                    continue;
                }
                if (g == null) continue;
                googlePurchase.state = 200;
                googlePurchase.purchaseState = 0;
                if (GoogleBillingUtil.getInstance().isAutoConsumeAsync()) {
                    googlePurchase.consumptionState = 1;
                }
                g.onVerifyFinish(googlePurchase);
                continue;
            }
            if (googlePurchase.state == 500) {
                if (g == null) continue;
                g.onVerifyFinish(googlePurchase);
                continue;
            }
            if (g == null) continue;
            g.onVerifyError(googlePurchase.state, googlePurchase);
        }
    }

    private boolean b(GooglePurchase googlePurchase) {
        try {
            long l = this.c.parse(googlePurchase.localTime).getTime();
            long l2 = System.currentTimeMillis() - l + 3000L;
            return l2 <= (long)this.d;
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return true;
        }
    }

    private void b() {
        this.a("[checkOrder] ");
        if (f == null) {
            this.a("[checkOrder] orders == null");
            return;
        }
        boolean bl = false;
        for (GooglePurchase googlePurchase : f) {
            if (googlePurchase.billingResponse != 0 || googlePurchase.state == 200) continue;
            bl = true;
            long l = System.currentTimeMillis();
            int n = 3000;
            switch (googlePurchase.state) {
                case 100: {
                    n = 3000;
                    break;
                }
                case 500: {
                    n = 300000;
                }
            }
            this.a("[checkOrder] -> send - time: " + n);
            if (l - googlePurchase.resultTime >= (long)n) {
                this.a("[checkOrder] -> send - orderId: " + googlePurchase.orderId);
                this.a(googlePurchase);
                continue;
            }
            this.a("[checkOrder] -> send - wait for next time, orderId: " + googlePurchase.orderId);
        }
        if (!bl) {
            this.d();
        } else {
            this.a("[checkOrder] -> sendEmptyMessageDelayed");
            this.j.sendEmptyMessageDelayed(0, 3000L);
        }
    }

    private void c() {
        if (this.i) {
            this.a("[startCheckOrder] runTimer is true, return");
            return;
        }
        this.a("[startCheckOrder]");
        this.i = true;
        this.j.sendEmptyMessageDelayed(0, 3000L);
    }

    private void d() {
        this.a("[stopCheckOrder]");
        this.i = false;
        this.j.removeMessages(0);
        this.j.removeCallbacksAndMessages(null);
    }

    private void a(String string) {
        if (GoogleBillingUtil.getInstance().a) {
            Log.i((String)"SDK_YiFans_Verify", (String)string);
        }
    }

    public static interface OnVerifyPurchaseListener {
        public void onVerifyFinish(GooglePurchase var1);

        public void onVerifyError(int var1, GooglePurchase var2);
    }
}

