/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase.http;

import android.util.Log;
import com.yifants.sdk.purchase.http.Callback;
import com.yifants.sdk.purchase.http.Request;
import com.yifants.sdk.purchase.http.Response;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;

public class HttpClient {
    public static ExecutorService executorService = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public static void get(final Request request, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int i = 1;
                while (true) {
                    try {
                        Response respose = HttpClient.get(request);
                        callback.onResponse(respose);
                    }
                    catch (IOException e) {
                        if (++i <= request.retry) continue;
                        callback.onFailure(request, e);
                    }
                    break;
                }
            }
        };
        executorService.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response get(Request request) throws IOException {
        if (request == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(request.url);
            request.addRequestHeader("Connection", "close");
        }
        catch (MalformedURLException e) {
            Log.e((String)"url error", (String)("url=" + request.url), (Throwable)e);
        }
        if (url == null) {
            return null;
        }
        HttpURLConnection httpUrlConnection = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.setConnectTimeout(request.connTimeout);
            httpUrlConnection.setReadTimeout(request.readTimeout);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestProperty("Accept-Encoding", "gzip");
            httpUrlConnection.setRequestProperty("Connection", "close");
            if (request.requestHeader != null) {
                for (Map.Entry<String, String> entry : request.requestHeader.entrySet()) {
                    httpUrlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            int responseCode = httpUrlConnection.getResponseCode();
            long contentLength = -1L;
            String contentLengthValue = httpUrlConnection.getHeaderField("Content-Length");
            if (contentLengthValue != null) {
                try {
                    contentLength = Long.parseLong(contentLengthValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Response response = new Response();
            response.responseCode = responseCode;
            response.responseHeader = httpUrlConnection.getHeaderFields();
            if (responseCode == 200) {
                String contentEncodeing = httpUrlConnection.getHeaderField("Content-Encoding");
                inputStream = httpUrlConnection.getInputStream();
                if ("gzip".equals(contentEncodeing)) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                long responseLength = HttpClient.copy(inputStream, output);
                if (contentLength != -1L && !"gzip".equals(contentEncodeing) && contentLength != responseLength) {
                    Response response2 = null;
                    return response2;
                }
                response.responseContent = output.toByteArray();
                outputStream = output;
                Response response3 = response;
                return response3;
            }
            if (responseCode >= 400) {
                throw new IOException("Server Side is Error!");
            }
            Response response4 = response;
            return response4;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
    }

    public static void post(final Request request, final String content, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int i = 1;
                while (true) {
                    try {
                        Response respose = HttpClient.post(request, content);
                        callback.onResponse(respose);
                    }
                    catch (IOException e) {
                        if (++i <= request.retry) continue;
                        callback.onFailure(request, e);
                    }
                    break;
                }
            }
        };
        executorService.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response post(Request request, String content) throws IOException {
        URL url;
        try {
            url = new URL(request.url);
            request.addRequestHeader("Connection", "close");
        }
        catch (MalformedURLException e) {
            throw new IOException("Create Url object error! url=" + request.url);
        }
        HttpURLConnection httpUrlConnection = null;
        InputStream inputStream = null;
        FilterOutputStream writeDataOutput = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            httpUrlConnection = (HttpURLConnection)url.openConnection();
            httpUrlConnection.setDoInput(true);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setConnectTimeout(request.connTimeout);
            httpUrlConnection.setReadTimeout(request.readTimeout);
            httpUrlConnection.setUseCaches(false);
            httpUrlConnection.setRequestProperty("Content-Type", "application/json");
            if (request.requestHeader != null) {
                for (Map.Entry<String, String> entry : request.requestHeader.entrySet()) {
                    httpUrlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            writeDataOutput = new DataOutputStream(httpUrlConnection.getOutputStream());
            ((DataOutputStream)writeDataOutput).writeBytes(content);
            ((DataOutputStream)writeDataOutput).flush();
            int responseCode = httpUrlConnection.getResponseCode();
            long contentLength = -1L;
            String contentLengthValue = httpUrlConnection.getHeaderField("Content-Length");
            if (contentLengthValue != null) {
                try {
                    contentLength = Long.parseLong(contentLengthValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Response response = new Response();
            response.responseCode = responseCode;
            response.responseHeader = httpUrlConnection.getHeaderFields();
            if (responseCode == 200) {
                String contentEncodeing = httpUrlConnection.getHeaderField("Content-Encoding");
                inputStream = httpUrlConnection.getInputStream();
                if ("gzip".equals(contentEncodeing)) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                long responseLength = HttpClient.copy(inputStream, byteArrayOutputStream);
                if (contentLength != -1L && !"gzip".equals(contentEncodeing) && contentLength != responseLength) {
                    Response response2 = null;
                    return response2;
                }
                response.responseContent = byteArrayOutputStream.toByteArray();
                Response response3 = response;
                return response3;
            }
            if (responseCode >= 400) {
                throw new IOException("Server Side is Error!");
            }
            Response response4 = response;
            return response4;
        }
        finally {
            if (writeDataOutput != null) {
                try {
                    writeDataOutput.close();
                }
                catch (Exception exception) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpUrlConnection != null) {
                httpUrlConnection.disconnect();
            }
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

