/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.SkuDetails;
import com.yifants.sdk.purchase.AESCipher;
import com.yifants.sdk.purchase.Constant;
import com.yifants.sdk.purchase.GoogleBillingUtil;
import com.yifants.sdk.purchase.GooglePurchase;
import com.yifants.sdk.purchase.PlayServicesUtils;
import com.yifants.sdk.purchase.http.Callback;
import com.yifants.sdk.purchase.http.HttpUtils;
import com.yifants.sdk.purchase.http.Request;
import com.yifants.sdk.purchase.http.Response;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public class VerifyPurchaseUtil {
    private static final String TAG = "SDK_YiFans_Verify";
    private static final VerifyPurchaseUtil verifyPurchase = new VerifyPurchaseUtil();
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'Z");
    private String url = "http://iap.go2s.co/api/purchase/google";
    private String pass = "s30cGbimxIYtVvsx";
    private static ArrayList<GooglePurchase> orders = null;
    private static OnVerifyPurchaseListener mOnVerifyPurchaseListener = null;
    private boolean isInit = false;
    private boolean runTimer = false;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            VerifyPurchaseUtil.this.log("[handleMessage] to checkOrder -->");
            VerifyPurchaseUtil.this.checkOrder();
        }
    };

    private VerifyPurchaseUtil() {
    }

    public static VerifyPurchaseUtil getInstance() {
        return verifyPurchase;
    }

    public VerifyPurchaseUtil build(Context context) {
        this.init(context);
        this.isInit = true;
        return verifyPurchase;
    }

    public boolean isInit() {
        return this.isInit;
    }

    private void init(Context context) {
        Constant.platform = "1";
        Constant.language = Locale.getDefault().getLanguage();
        Constant.country = Locale.getDefault().getCountry();
        Constant.osv = Build.VERSION.RELEASE;
        Constant.model = Build.MODEL;
        PlayServicesUtils.getPlayAdId(context, new PlayServicesUtils.PlayAdIdReadListener(){

            @Override
            public void onPlayAdIdRead(String playAdId) {
                Constant.gaid = playAdId;
            }
        });
    }

    public VerifyPurchaseUtil setOnVerifyPurchaseListener(OnVerifyPurchaseListener onVerifyPurchaseListener) {
        mOnVerifyPurchaseListener = onVerifyPurchaseListener;
        return verifyPurchase;
    }

    public void verifyPurchase(int responseCode, List<Purchase> list) {
        this.log("[verifyPurchase] responseCode: " + responseCode);
        if (list == null || list.isEmpty()) {
            this.log("[verifyPurchase] Purchase list is empty, return");
            return;
        }
        if (orders == null || orders.size() == 0) {
            orders = new ArrayList();
        }
        for (Purchase purchase : list) {
            GooglePurchase order = new GooglePurchase();
            order.orderId = purchase.getOrderId();
            order.packageName = purchase.getPackageName();
            order.purchaseTime = purchase.getPurchaseTime();
            order.purchaseToken = purchase.getPurchaseToken();
            order.productId = purchase.getSku();
            order.billingResponse = responseCode;
            order.localTime = this.format.format(new Date());
            orders.add(order);
            this.send(order);
        }
    }

    private void send(GooglePurchase order) {
        if (order == null) {
            return;
        }
        final JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("orderId", (Object)order.orderId);
            jsonObject.put("packageName", (Object)order.packageName);
            jsonObject.put("purchaseTime", order.purchaseTime);
            jsonObject.put("purchaseToken", (Object)order.purchaseToken);
            jsonObject.put("productId", (Object)order.productId);
            jsonObject.put("billingResponse", order.billingResponse);
            jsonObject.put("localTime", (Object)order.localTime);
            SkuDetails skuDetail = GoogleBillingUtil.getInstance().getSkuDetail(order.productId);
            if (skuDetail != null) {
                jsonObject.put("price", (Object)skuDetail.getPrice());
                jsonObject.put("priceCurrencyCode", (Object)skuDetail.getPriceCurrencyCode());
            } else {
                if (GoogleBillingUtil.getInstance().skuDetails == null || GoogleBillingUtil.getInstance().skuDetails.size() == 0) {
                    if (GoogleBillingUtil.getInstance().startConnection()) {
                        GoogleBillingUtil.getInstance().queryInventoryInApp();
                        GoogleBillingUtil.getInstance().queryInventorySubs();
                    }
                    this.log("[send] skuDetail is null, will try to get skuDetail of this order[" + order.orderId + "] - sku[" + order.productId + "] again");
                    this.setOrderState(order.orderId, 100, -1);
                    return;
                }
                this.log("[send] can not find the skuDetail of this order[" + order.orderId + "] - sku[" + order.productId + "]");
            }
            jsonObject.put("platform", (Object)Constant.platform);
            jsonObject.put("gaid", (Object)Constant.gaid);
            jsonObject.put("osv", (Object)Constant.osv);
            jsonObject.put("model", (Object)Constant.model);
            jsonObject.put("language", (Object)Constant.language);
            jsonObject.put("country", (Object)Constant.country);
            String data = jsonObject.toString();
            data = AESCipher.aesEncryptString(data, "xlgfs9u*ZVXqaF8^");
            JSONObject dataObject = new JSONObject();
            dataObject.put("sign", (Object)data);
            this.log("[send] \u542f\u52a8\u9a8c\u8bc1 orderId==>" + order.orderId);
            HttpUtils.post(this.url, dataObject.toString(), new Callback(){

                @Override
                public void onResponse(Response response) {
                    try {
                        String respContent = new String(response.responseContent, "utf-8");
                        VerifyPurchaseUtil.this.log("[send] respContent==>" + respContent);
                        respContent = AESCipher.aesDecryptString(respContent, "xlgfs9u*ZVXqaF8^");
                        JSONObject result = new JSONObject(respContent);
                        int code = result.optInt("code");
                        String orderId = jsonObject.optString("orderId");
                        int purchaseState = -1;
                        if (code == 200) {
                            JSONObject data = result.optJSONObject("data");
                            if (data != null) {
                                orderId = data.optString("orderId");
                                purchaseState = data.optInt("purchaseState");
                            }
                        } else {
                            String msg = result.optString("msg");
                            VerifyPurchaseUtil.this.log("[send] \u9a8c\u8bc1\u7ed3\u679c\u4e3a code==>" + code + " , msg==>" + msg + ", next will check order again with google");
                        }
                        VerifyPurchaseUtil.this.log("[send] \u9a8c\u8bc1\u7ed3\u679c\u4e3a orderId==>" + orderId + " , state==>" + code);
                        VerifyPurchaseUtil.this.setOrderState(orderId, code, purchaseState);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailure(Request request, IOException e) {
                    VerifyPurchaseUtil.this.log("[send] onFailure: " + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setOrderState(String orderId, int state, int purchaseState) {
        this.log("[setOrderState] orderId: " + orderId + "; responseState: " + state + "; purchaseState: " + purchaseState);
        if (orders == null) {
            this.log("[setOrderState] orders == null");
            return;
        }
        for (GooglePurchase item : orders) {
            boolean hasNotChecked;
            if (item.billingResponse != 0 || !orderId.equals(item.orderId)) continue;
            item.state = state;
            boolean bl = hasNotChecked = item.purchaseState == -1;
            if (hasNotChecked) {
                item.purchaseState = purchaseState;
            }
            item.resultTime = System.currentTimeMillis();
            if (item.state == 200) {
                if (hasNotChecked && mOnVerifyPurchaseListener != null) {
                    if (purchaseState == 0) {
                        this.log("[setOrderState] onVerifyFinish - " + item.orderId);
                        mOnVerifyPurchaseListener.onVerifyFinish(item);
                        continue;
                    }
                    this.log("[setOrderState] onVerifyError - " + item.orderId);
                    mOnVerifyPurchaseListener.onVerifyError(purchaseState, item);
                    continue;
                }
                this.log("[setOrderState] hasNotChecked: " + hasNotChecked + " or mOnVerifyPurchaseListener == null");
                continue;
            }
            if (!hasNotChecked) continue;
            this.startCheckOrder();
        }
    }

    private void checkOrder() {
        this.log("[checkOrder] ");
        if (orders == null) {
            this.log("[checkOrder] orders == null");
            return;
        }
        boolean result = false;
        for (GooglePurchase item : orders) {
            if (item.billingResponse != 0 || item.state == 200) continue;
            result = true;
            long currentIime = System.currentTimeMillis();
            int timeOut = 3000;
            switch (item.state) {
                case 100: {
                    timeOut = 3000;
                    break;
                }
                case 500: {
                    timeOut = 300000;
                }
            }
            this.log("[checkOrder] -> send - time: " + timeOut);
            if (currentIime - item.resultTime >= (long)timeOut) {
                this.log("[checkOrder] -> send - orderId: " + item.orderId);
                this.send(item);
                continue;
            }
            this.log("[checkOrder] -> send - wait for next time, orderId: " + item.orderId);
        }
        if (!result) {
            this.stopCheckOrder();
        } else {
            this.log("[checkOrder] -> sendEmptyMessageDelayed");
            this.handler.sendEmptyMessageDelayed(0, 3000L);
        }
    }

    private static void clean() {
        mOnVerifyPurchaseListener = null;
        orders = null;
    }

    private void startCheckOrder() {
        if (this.runTimer) {
            this.log("[startCheckOrder] runTimer is true, return");
            return;
        }
        this.log("[startCheckOrder] 3\u79d2\u540e \u542f\u52a8\u8ba2\u5355\u68c0\u6d4b");
        this.runTimer = true;
        this.handler.sendEmptyMessageDelayed(0, 3000L);
    }

    private void stopCheckOrder() {
        this.log("[stopCheckOrder] \u505c\u6b62\u8ba2\u5355\u68c0\u6d4b");
        this.runTimer = false;
        this.handler.removeMessages(0);
        this.handler.removeCallbacksAndMessages(null);
    }

    private void log(String msg) {
        if (GoogleBillingUtil.getInstance().IS_DEBUG) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public static interface OnVerifyPurchaseListener {
        public void onVerifyFinish(GooglePurchase var1);

        public void onVerifyError(int var1, GooglePurchase var2);
    }
}

