/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;

class PlayServicesUtils {
    private static final String LOG_TAG = "PlayServicesHelper";

    PlayServicesUtils() {
    }

    static String getPlayAdId(Context context) {
        try {
            AdvertisingIdClient.Info advertisingIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context.getApplicationContext());
            return advertisingIdInfo.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    static void getPlayAdId(Context context, final PlayAdIdReadListener listener) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            Log.i((String)LOG_TAG, (String)"Reading GoogleAdId in background thread");
            String playAdId = PlayServicesUtils.getPlayAdId(context);
            listener.onPlayAdIdRead(playAdId);
            return;
        }
        new AsyncTask<Context, Void, String>(){

            protected String doInBackground(Context ... params) {
                Context innerContext = params[0];
                return PlayServicesUtils.getPlayAdId(innerContext);
            }

            protected void onPostExecute(String playAdId) {
                listener.onPlayAdIdRead(playAdId);
            }
        }.execute((Object[])new Context[]{context});
    }

    static interface PlayAdIdReadListener {
        public void onPlayAdIdRead(String var1);
    }
}

