/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase.http;

import android.util.Log;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class Request {
    public int connTimeout = 30000;
    public int readTimeout = 30000;
    public int retry = 3;
    public Map<String, String> requestHeader;
    public String url;

    public Request(String url) {
        if (url.contains(" ")) {
            try {
                String prefixUrl = url.substring(0, url.lastIndexOf("/") + 1);
                String suffixUrl = url.substring(url.lastIndexOf("/") + 1);
                url = prefixUrl + URLEncoder.encode(suffixUrl, "UTF-8");
                url = url.replaceAll("\\+", "%20");
            }
            catch (Exception e) {
                Log.e((String)"url error", (String)("url=" + url), (Throwable)e);
            }
        }
        this.url = url;
    }

    public Request(String url, int connTimeout, int readTimeout) {
        this(url);
        this.connTimeout = connTimeout;
        this.readTimeout = readTimeout;
    }

    public void addRequestHeader(String key, String value) {
        if (this.requestHeader == null) {
            this.requestHeader = new HashMap<String, String>();
        }
        this.requestHeader.put(key, value);
    }

    public void addRequestHeaders(Map<String, String> requestHeader) {
        this.requestHeader = requestHeader;
    }
}

