/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtil {
    private static final String ENCRY_ALGORITHM = "AES";
    private static final String CIPHER_MODE = "AES/ECB/PKCS5Padding";
    private static final String IV_ = null;
    private static final String CHARACTER = "UTF-8";
    private static final int PWD_SIZE = 16;

    private static byte[] pwdHandler(String password) throws UnsupportedEncodingException {
        byte[] data = null;
        if (password == null) {
            password = "";
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(password);
        while (sb.length() < 16) {
            sb.append("0");
        }
        if (sb.length() > 16) {
            sb.setLength(16);
        }
        data = sb.toString().getBytes(CHARACTER);
        return data;
    }

    public static byte[] encrypt(byte[] clearTextBytes, byte[] pwdBytes) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(pwdBytes, ENCRY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(1, keySpec);
            byte[] cipherTextBytes = cipher.doFinal(clearTextBytes);
            return cipherTextBytes;
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] decrypt(byte[] cipherTextBytes, byte[] pwdBytes) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(pwdBytes, ENCRY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_MODE);
            cipher.init(2, keySpec);
            byte[] clearTextBytes = cipher.doFinal(cipherTextBytes);
            return clearTextBytes;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String encryptBase64(String clearText, String password) {
        try {
            byte[] cipherTextBytes = EncryptUtil.encrypt(clearText.getBytes(CHARACTER), EncryptUtil.pwdHandler(password));
            String cipherText = new String(Base64.encode((byte[])cipherTextBytes, (int)0));
            return cipherText;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String decryptBase64(String cipherText, String password) {
        try {
            byte[] cipherTextBytes = Base64.decode((String)cipherText, (int)0);
            byte[] clearTextBytes = EncryptUtil.decrypt(cipherTextBytes, EncryptUtil.pwdHandler(password));
            return new String(clearTextBytes, CHARACTER);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String encryptHex(String clearText, String password) {
        try {
            byte[] cipherTextBytes = EncryptUtil.encrypt(clearText.getBytes(CHARACTER), EncryptUtil.pwdHandler(password));
            String cipherText = EncryptUtil.byte2hex(cipherTextBytes);
            return cipherText;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String decryptHex(String cipherText, String password) {
        try {
            byte[] cipherTextBytes = EncryptUtil.hex2byte(cipherText);
            byte[] clearTextBytes = EncryptUtil.decrypt(cipherTextBytes, EncryptUtil.pwdHandler(password));
            return new String(clearTextBytes, CHARACTER);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String byte2hex(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        String tmp = "";
        for (int n = 0; n < bytes.length; ++n) {
            tmp = Integer.toHexString(bytes[n] & 0xFF);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return sb.toString().toUpperCase();
    }

    private static byte[] hex2byte(String str) {
        if (str == null || str.length() < 2) {
            return new byte[0];
        }
        str = str.toLowerCase();
        int l = str.length() / 2;
        byte[] result = new byte[l];
        for (int i = 0; i < l; ++i) {
            String tmp = str.substring(2 * i, 2 * i + 2);
            result[i] = (byte)(Integer.parseInt(tmp, 16) & 0xFF);
        }
        return result;
    }
}

