/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase;

import android.app.Activity;
import android.content.Context;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleBillingUtil {
    private static final String TAG = "GoogleBillingUtil";
    private static final boolean IS_DEBUG = false;
    private String[] inAppSKUS = new String[0];
    private String[] subsSKUS = new String[0];
    public List<SkuDetails> skuDetails = null;
    public static final String BILLING_TYPE_INAPP = "inapp";
    public static final String BILLING_TYPE_SUBS = "subs";
    private static BillingClient mBillingClient;
    private static BillingClient.Builder builder;
    private static OnPurchaseFinishedListener mOnPurchaseFinishedListener;
    private static OnStartSetupFinishedListener mOnStartSetupFinishedListener;
    private static OnQueryFinishedListener mOnQueryFinishedListener;
    private static OnConsumeFinishedListener mOnConsumeFinishedListener;
    private boolean isAutoConsumeAsync = false;
    private static final GoogleBillingUtil mGoogleBillingUtil;

    private GoogleBillingUtil() {
    }

    public static GoogleBillingUtil getInstance() {
        return mGoogleBillingUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleBillingUtil build(Context context) {
        GoogleBillingUtil googleBillingUtil;
        if (mBillingClient == null) {
            googleBillingUtil = mGoogleBillingUtil;
            synchronized (googleBillingUtil) {
                if (mBillingClient == null) {
                    if (GoogleBillingUtil.isGooglePlayServicesAvailable(context)) {
                        builder = BillingClient.newBuilder((Context)context);
                        GoogleBillingUtil googleBillingUtil2 = mGoogleBillingUtil;
                        googleBillingUtil2.getClass();
                        mBillingClient = builder.setListener((PurchasesUpdatedListener)googleBillingUtil2.new MyPurchasesUpdatedListener()).build();
                    } else if (mOnStartSetupFinishedListener != null) {
                        mOnStartSetupFinishedListener.onSetupError();
                    }
                } else {
                    GoogleBillingUtil googleBillingUtil3 = mGoogleBillingUtil;
                    googleBillingUtil3.getClass();
                    builder.setListener((PurchasesUpdatedListener)googleBillingUtil3.new MyPurchasesUpdatedListener());
                }
            }
        } else {
            GoogleBillingUtil googleBillingUtil4 = mGoogleBillingUtil;
            googleBillingUtil4.getClass();
            builder.setListener((PurchasesUpdatedListener)googleBillingUtil4.new MyPurchasesUpdatedListener());
        }
        googleBillingUtil = mGoogleBillingUtil;
        synchronized (googleBillingUtil) {
            if (mGoogleBillingUtil.startConnection()) {
                mGoogleBillingUtil.queryInventoryInApp();
                mGoogleBillingUtil.queryInventorySubs();
                mGoogleBillingUtil.queryPurchasesInApp();
            }
        }
        return mGoogleBillingUtil;
    }

    public boolean startConnection() {
        if (mBillingClient == null) {
            GoogleBillingUtil.log("\u521d\u59cb\u5316\u5931\u8d25:mBillingClient==null");
            return false;
        }
        if (!mBillingClient.isReady()) {
            mBillingClient.startConnection(new BillingClientStateListener(){

                public void onBillingSetupFinished(int billingResponseCode) {
                    if (billingResponseCode == 0) {
                        GoogleBillingUtil.this.queryInventoryInApp();
                        GoogleBillingUtil.this.queryInventorySubs();
                        GoogleBillingUtil.this.queryPurchasesInApp();
                        if (mOnStartSetupFinishedListener != null) {
                            mOnStartSetupFinishedListener.onSetupSuccess();
                        }
                    } else {
                        GoogleBillingUtil.log("\u521d\u59cb\u5316\u5931\u8d25:onSetupFail:code=" + billingResponseCode);
                        if (mOnStartSetupFinishedListener != null) {
                            mOnStartSetupFinishedListener.onSetupFail(billingResponseCode);
                        }
                    }
                }

                public void onBillingServiceDisconnected() {
                    if (mOnStartSetupFinishedListener != null) {
                        mOnStartSetupFinishedListener.onSetupError();
                    }
                    GoogleBillingUtil.log("\u521d\u59cb\u5316\u5931\u8d25:onBillingServiceDisconnected");
                }
            });
            return false;
        }
        return true;
    }

    public void queryInventoryInApp() {
        this.queryInventory(BILLING_TYPE_INAPP);
    }

    public void queryInventorySubs() {
        this.queryInventory(BILLING_TYPE_SUBS);
    }

    private void queryInventory(final String skuType) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (mBillingClient == null) {
                    if (mOnQueryFinishedListener != null) {
                        mOnQueryFinishedListener.onQueryError();
                    }
                    return;
                }
                ArrayList skuList = new ArrayList();
                if (skuType.equals(GoogleBillingUtil.BILLING_TYPE_INAPP)) {
                    Collections.addAll(skuList, GoogleBillingUtil.this.inAppSKUS);
                } else if (skuType.equals(GoogleBillingUtil.BILLING_TYPE_SUBS)) {
                    Collections.addAll(skuList, GoogleBillingUtil.this.subsSKUS);
                }
                SkuDetailsParams.Builder params = SkuDetailsParams.newBuilder();
                params.setSkusList(skuList).setType(skuType);
                mBillingClient.querySkuDetailsAsync(params.build(), (SkuDetailsResponseListener)new MySkuDetailsResponseListener(mOnQueryFinishedListener, skuType));
            }
        };
        this.executeServiceRequest(runnable);
    }

    public void purchaseInApp(Activity activity, String skuId) {
        this.purchase(activity, skuId, BILLING_TYPE_INAPP);
    }

    public void purchaseSubs(Activity activity, String skuId) {
        this.purchase(activity, skuId, BILLING_TYPE_SUBS);
    }

    private void purchase(Activity activity, String skuId, String skuType) {
        if (mBillingClient == null) {
            if (mOnPurchaseFinishedListener != null) {
                mOnPurchaseFinishedListener.onPurchaseError();
            }
            return;
        }
        if (this.startConnection()) {
            try {
                JSONObject skuJob = new JSONObject();
                skuJob.put("productId", (Object)skuId);
                skuJob.put("type", (Object)skuType);
                SkuDetails skuDetails = new SkuDetails(skuJob.toString());
                BillingFlowParams flowParams = BillingFlowParams.newBuilder().setSkuDetails(skuDetails).build();
                mBillingClient.launchBillingFlow(activity, flowParams);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else if (mOnPurchaseFinishedListener != null) {
            mOnPurchaseFinishedListener.onPurchaseError();
        }
    }

    public void consumeAsync(String purchaseToken) {
        if (mBillingClient == null) {
            return;
        }
        mBillingClient.consumeAsync(purchaseToken, (ConsumeResponseListener)new MyConsumeResponseListener());
    }

    public List<Purchase> queryPurchasesInApp() {
        return this.queryPurchases(BILLING_TYPE_INAPP);
    }

    public List<Purchase> queryPurchasesSubs() {
        return this.queryPurchases(BILLING_TYPE_SUBS);
    }

    private List<Purchase> queryPurchases(String skuType) {
        if (mBillingClient == null) {
            return null;
        }
        if (!mBillingClient.isReady()) {
            this.startConnection();
        } else {
            Purchase.PurchasesResult purchasesResult = mBillingClient.queryPurchases(skuType);
            if (purchasesResult != null && purchasesResult.getResponseCode() == 0) {
                List purchaseList = purchasesResult.getPurchasesList();
                if (this.isAutoConsumeAsync && purchaseList != null) {
                    for (Purchase purchase : purchaseList) {
                        if (!skuType.equals(BILLING_TYPE_INAPP)) continue;
                        this.consumeAsync(purchase.getPurchaseToken());
                    }
                }
                return purchaseList;
            }
        }
        return null;
    }

    public int getPurchasesSizeSubs() {
        List<Purchase> list = this.queryPurchasesSubs();
        if (list != null) {
            return list.size();
        }
        return -1;
    }

    public int getSubsPositionBySku(String sku) {
        return this.getPositionBySku(sku, BILLING_TYPE_SUBS);
    }

    public int getInAppPositionBySku(String sku) {
        return this.getPositionBySku(sku, BILLING_TYPE_INAPP);
    }

    private int getPositionBySku(String sku, String skuType) {
        block5: {
            block4: {
                if (!skuType.equals(BILLING_TYPE_INAPP)) break block4;
                int i = 0;
                for (String s : this.inAppSKUS) {
                    if (s.equals(sku)) {
                        return i;
                    }
                    ++i;
                }
                break block5;
            }
            if (!skuType.equals(BILLING_TYPE_SUBS)) break block5;
            int i = 0;
            for (String s : this.subsSKUS) {
                if (s.equals(sku)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void executeServiceRequest(Runnable runnable) {
        if (this.startConnection()) {
            runnable.run();
        }
    }

    public String getSubsSkuByPosition(int position) {
        if (position >= 0 && position < this.subsSKUS.length) {
            return this.subsSKUS[position];
        }
        return null;
    }

    public String getInAppSkuByPosition(int position) {
        if (position >= 0 && position < this.inAppSKUS.length) {
            return this.inAppSKUS[position];
        }
        return null;
    }

    private String getSkuType(String sku) {
        if (Arrays.asList(this.inAppSKUS).contains(sku)) {
            return BILLING_TYPE_INAPP;
        }
        if (Arrays.asList(this.subsSKUS).contains(sku)) {
            return BILLING_TYPE_SUBS;
        }
        return null;
    }

    public SkuDetails getSkuDetail(String sku) {
        if (this.skuDetails == null) {
            return null;
        }
        for (SkuDetails item : this.skuDetails) {
            if (!sku.equals(item.getSku())) continue;
            return item;
        }
        return null;
    }

    public static boolean isGooglePlayServicesAvailable(Context context) {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        if (googleApiAvailability != null) {
            int resultCode = googleApiAvailability.isGooglePlayServicesAvailable(context);
            return resultCode == 0;
        }
        return false;
    }

    public GoogleBillingUtil setOnQueryFinishedListener(OnQueryFinishedListener onQueryFinishedListener) {
        mOnQueryFinishedListener = onQueryFinishedListener;
        return mGoogleBillingUtil;
    }

    public GoogleBillingUtil setOnPurchaseFinishedListener(OnPurchaseFinishedListener onPurchaseFinishedListener) {
        mOnPurchaseFinishedListener = onPurchaseFinishedListener;
        return mGoogleBillingUtil;
    }

    public GoogleBillingUtil setOnConsumeFinishedListener(OnConsumeFinishedListener onConsumeFinishedListener) {
        mOnConsumeFinishedListener = onConsumeFinishedListener;
        return mGoogleBillingUtil;
    }

    public GoogleBillingUtil setOnStartSetupFinishedListener(OnStartSetupFinishedListener onStartSetupFinishedListener) {
        mOnStartSetupFinishedListener = onStartSetupFinishedListener;
        return mGoogleBillingUtil;
    }

    public GoogleBillingUtil setInAppSKUS(String[] inAppSKUS) {
        this.inAppSKUS = inAppSKUS;
        return mGoogleBillingUtil;
    }

    public GoogleBillingUtil setSubsSKUS(String[] subsSKUS) {
        this.subsSKUS = subsSKUS;
        return mGoogleBillingUtil;
    }

    public GoogleBillingUtil setAutoConsumeAsync(boolean autoConsumeAsync) {
        this.isAutoConsumeAsync = autoConsumeAsync;
        return mGoogleBillingUtil;
    }

    public boolean isReady() {
        return mBillingClient != null && mBillingClient.isReady();
    }

    public boolean isAutoConsumeAsync() {
        return this.isAutoConsumeAsync;
    }

    public void setIsAutoConsumeAsync(boolean isAutoConsumeAsync) {
        this.isAutoConsumeAsync = isAutoConsumeAsync;
    }

    public static void cleanListener() {
        mOnPurchaseFinishedListener = null;
        mOnQueryFinishedListener = null;
        mOnStartSetupFinishedListener = null;
        if (builder != null) {
            builder.setListener(null);
        }
    }

    public static void endConnection() {
        if (mBillingClient != null && mBillingClient.isReady()) {
            mBillingClient.endConnection();
            mBillingClient = null;
        }
    }

    private static void log(String msg) {
    }

    static {
        mGoogleBillingUtil = new GoogleBillingUtil();
    }

    public static interface OnStartSetupFinishedListener {
        public void onSetupSuccess();

        public void onSetupFail(int var1);

        public void onSetupError();
    }

    public static interface OnConsumeFinishedListener {
        public void onConsumeSuccess(String var1);

        public void onConsumeFail(int var1, String var2);
    }

    public static interface OnPurchaseFinishedListener {
        public void onPurchaseSuccess(int var1, List<Purchase> var2);

        public void onPurchaseFail(int var1, List<Purchase> var2);

        public void onPurchaseError();
    }

    public static interface OnQueryFinishedListener {
        public void onQuerySuccess(String var1, List<SkuDetails> var2);

        public void onQueryFail(int var1, String var2, List<SkuDetails> var3);

        public void onQueryError();
    }

    private class MyConsumeResponseListener
    implements ConsumeResponseListener {
        private MyConsumeResponseListener() {
        }

        public void onConsumeResponse(int responseCode, String purchaseToken) {
            if (mOnConsumeFinishedListener == null) {
                return;
            }
            if (responseCode == 0) {
                mOnConsumeFinishedListener.onConsumeSuccess(purchaseToken);
            } else {
                mOnConsumeFinishedListener.onConsumeFail(responseCode, purchaseToken);
            }
        }
    }

    private class MySkuDetailsResponseListener
    implements SkuDetailsResponseListener {
        private OnQueryFinishedListener mOnQueryFinishedListener;
        private String skuType;

        public MySkuDetailsResponseListener(OnQueryFinishedListener onQueryFinishedListener, String skuType) {
            this.mOnQueryFinishedListener = onQueryFinishedListener;
            this.skuType = skuType;
        }

        public void onSkuDetailsResponse(int responseCode, List<SkuDetails> list) {
            if (this.mOnQueryFinishedListener == null) {
                return;
            }
            if (responseCode == 0 && list != null) {
                this.mOnQueryFinishedListener.onQuerySuccess(this.skuType, list);
                GoogleBillingUtil.this.skuDetails = new ArrayList<SkuDetails>(list.size());
                GoogleBillingUtil.this.skuDetails.addAll(list);
            } else {
                this.mOnQueryFinishedListener.onQueryFail(responseCode, this.skuType, list);
            }
        }
    }

    private class MyPurchasesUpdatedListener
    implements PurchasesUpdatedListener {
        private MyPurchasesUpdatedListener() {
        }

        public void onPurchasesUpdated(int responseCode, List<Purchase> list) {
            if (mOnPurchaseFinishedListener == null) {
                return;
            }
            if (responseCode == 0 && list != null) {
                if (GoogleBillingUtil.this.isAutoConsumeAsync) {
                    for (Purchase purchase : list) {
                        String skuType;
                        String sku = purchase.getSku();
                        if (sku == null || (skuType = GoogleBillingUtil.this.getSkuType(sku)) == null || !skuType.equals(GoogleBillingUtil.BILLING_TYPE_INAPP)) continue;
                        GoogleBillingUtil.this.consumeAsync(purchase.getPurchaseToken());
                    }
                }
                mOnPurchaseFinishedListener.onPurchaseSuccess(responseCode, list);
            } else {
                mOnPurchaseFinishedListener.onPurchaseFail(responseCode, list);
            }
        }
    }
}

