/*
 * Decompiled with CFR 0.152.
 */
package com.yifants.sdk.purchase;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.AcknowledgePurchaseResponseListener;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.ConsumeResponseListener;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.yifants.sdk.purchase.GooglePurchase;
import com.yifants.sdk.purchase.VerifyPurchaseUtil;
import com.yifants.sdk.purchase.a.b;
import com.yifants.sdk.purchase.d.c;
import com.yifants.sdk.purchase.d.d;
import com.yifants.sdk.purchase.d.e;
import com.yifants.sdk.purchase.e.a;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleBillingUtil {
    boolean a = false;
    private List<String> e = null;
    private List<String> f = null;
    HashMap<String, SkuDetails> b = new HashMap();
    private BillingClient g;
    private BillingClient.Builder h;
    private OnPurchaseFinishedListener i;
    private OnStartSetupFinishedListener j;
    private OnQueryUnConsumeOrderListener k;
    private OnQueryHistoryQurchaseListener l;
    private OnQueryFinishedListener m;
    private OnConsumeFinishedListener n;
    private boolean o = false;
    private VerifyPurchaseUtil p;
    private Context q;
    private static final GoogleBillingUtil r = new GoogleBillingUtil();
    int c = 0;
    SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");

    public String getVersion() {
        return "2.0.0";
    }

    private GoogleBillingUtil() {
    }

    public static GoogleBillingUtil getInstance() {
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleBillingUtil build(Context context) {
        GoogleBillingUtil googleBillingUtil;
        this.d("YiFans Google Purchase SDK Version: " + this.getVersion());
        if (this.g == null) {
            googleBillingUtil = r;
            synchronized (googleBillingUtil) {
                if (this.g == null) {
                    this.q = context.getApplicationContext();
                    if (com.yifants.sdk.purchase.e.a.a(this.q)) {
                        this.h = BillingClient.newBuilder((Context)this.q);
                        this.g = this.h.setListener((PurchasesUpdatedListener)new MyPurchasesUpdatedListener()).enablePendingPurchases().build();
                    } else {
                        if (this.a) {
                            this.d("\u8b66\u544a:GooglePlay\u670d\u52a1\u5904\u4e8e\u4e0d\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5");
                        }
                        if (this.j != null) {
                            this.j.onSetupError();
                        }
                    }
                } else {
                    this.h.setListener((PurchasesUpdatedListener)new MyPurchasesUpdatedListener());
                }
            }
        } else {
            this.h.setListener((PurchasesUpdatedListener)new MyPurchasesUpdatedListener());
        }
        googleBillingUtil = r;
        synchronized (googleBillingUtil) {
            if (this.a()) {
                this.queryInventoryInApp();
                this.queryInventorySubs();
                this.queryPurchasesInApp();
            }
        }
        return r;
    }

    public boolean a() {
        if (this.g == null) {
            this.d("\u521d\u59cb\u5316\u5931\u8d25:mBillingClient==null");
            return false;
        }
        if (!this.g.isReady()) {
            this.g.startConnection(new BillingClientStateListener(){

                public void onBillingSetupFinished(BillingResult billingResult) {
                    GoogleBillingUtil.this.c = 0;
                    int n = billingResult.getResponseCode();
                    if (n == 0) {
                        GoogleBillingUtil.this.queryInventoryInApp();
                        GoogleBillingUtil.this.queryInventorySubs();
                        GoogleBillingUtil.this.queryPurchasesInApp();
                        if (GoogleBillingUtil.this.j != null) {
                            GoogleBillingUtil.this.j.onSetupSuccess();
                        }
                    } else {
                        GoogleBillingUtil.this.d("\u521d\u59cb\u5316\u5931\u8d25:onError:code=" + n);
                        if (GoogleBillingUtil.this.j != null) {
                            GoogleBillingUtil.this.j.onSetupFail(n);
                        }
                    }
                }

                public void onBillingServiceDisconnected() {
                    ++GoogleBillingUtil.this.c;
                    if (GoogleBillingUtil.this.c > 2) {
                        GoogleBillingUtil.this.c = 0;
                        GoogleBillingUtil.this.d("\u521d\u59cb\u5316\u5931\u8d25:onBillingServiceDisconnected");
                        if (GoogleBillingUtil.this.j != null) {
                            GoogleBillingUtil.this.j.onSetupError();
                        }
                    } else {
                        GoogleBillingUtil.this.a();
                    }
                }
            });
            return false;
        }
        return true;
    }

    private void a(final Purchase purchase) {
        String string;
        this.d(purchase.toString());
        if (!purchase.isAcknowledged()) {
            string = AcknowledgePurchaseParams.newBuilder().setPurchaseToken(purchase.getPurchaseToken()).build();
            AcknowledgePurchaseResponseListener acknowledgePurchaseResponseListener = new AcknowledgePurchaseResponseListener(){

                public void onAcknowledgePurchaseResponse(BillingResult billingResult) {
                    GoogleBillingUtil.this.d(purchase.getSku() + "_[acknowledgePurchase]: " + billingResult.getResponseCode());
                }
            };
            this.g.acknowledgePurchase((AcknowledgePurchaseParams)string, acknowledgePurchaseResponseListener);
        }
        if ("inapp".equals(string = this.getSkuType(purchase.getSku())) && this.o) {
            this.consumeAsync(purchase.getPurchaseToken());
        }
    }

    public void queryInventoryInApp() {
        this.a("inapp");
    }

    public void queryInventorySubs() {
        this.a("subs");
    }

    private void a(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (GoogleBillingUtil.this.g == null) {
                        if (GoogleBillingUtil.this.m != null) {
                            GoogleBillingUtil.this.m.onQueryError();
                        }
                        return;
                    }
                    SkuDetailsParams.Builder builder = SkuDetailsParams.newBuilder();
                    if (string.equals("inapp")) {
                        builder.setSkusList(GoogleBillingUtil.this.e).setType("inapp");
                    } else if (string.equals("subs")) {
                        builder.setSkusList(GoogleBillingUtil.this.f).setType("subs");
                    }
                    GoogleBillingUtil.this.g.querySkuDetailsAsync(builder.build(), (SkuDetailsResponseListener)new MySkuDetailsResponseListener(GoogleBillingUtil.this.m, string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.a(runnable);
    }

    public void purchaseInApp(Activity activity, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (this.i != null) {
                this.i.onPurchaseError("skuid is null!");
            }
            return;
        }
        if (this.b == null || this.b.isEmpty()) {
            if (this.i != null) {
                this.i.onPurchaseError("SDK init fail or SDK is initing!");
            }
            return;
        }
        SkuDetails skuDetails = this.b.get(string);
        if (skuDetails == null) {
            if (this.i != null) {
                this.i.onPurchaseError("This skuid was't seted when sdk init!");
            }
            return;
        }
        if (!"inapp".equals(skuDetails.getType())) {
            if (this.i != null) {
                this.i.onPurchaseError("This skuid's type is not 'inapp'!");
            }
            return;
        }
        this.a(activity, skuDetails);
    }

    public void purchaseSubs(Activity activity, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (this.i != null) {
                this.i.onPurchaseError("skuid is null!");
            }
            return;
        }
        if (this.b == null || this.b.isEmpty()) {
            if (this.i != null) {
                this.i.onPurchaseError("SDK init fail or SDK is initing!");
            }
            return;
        }
        SkuDetails skuDetails = this.b.get(string);
        if (skuDetails == null) {
            if (this.i != null) {
                this.i.onPurchaseError("This skuid was not seted when sdk init!");
            }
            return;
        }
        if (!"subs".equals(skuDetails.getType())) {
            if (this.i != null) {
                this.i.onPurchaseError("This skuid's type is not 'subs'!");
            }
            return;
        }
        this.a(activity, skuDetails);
    }

    private void a(Activity activity, SkuDetails skuDetails) {
        if (this.g == null) {
            if (this.i != null) {
                this.i.onPurchaseError("SDK unavailable, BillingClient is null!");
            }
            return;
        }
        if (this.a()) {
            BillingFlowParams billingFlowParams = BillingFlowParams.newBuilder().setSkuDetails(skuDetails).build();
            this.g.launchBillingFlow(activity, billingFlowParams);
        } else if (this.i != null) {
            this.i.onPurchaseError("SDK unavailable, disconnected google play services!");
        }
    }

    public void consumeAsync(String string) {
        if (this.g == null) {
            if (this.n != null) {
                this.n.onConsumeFail(204, string);
            }
            return;
        }
        ConsumeParams consumeParams = ConsumeParams.newBuilder().setPurchaseToken(string).build();
        this.g.consumeAsync(consumeParams, (ConsumeResponseListener)new MyConsumeResponseListener());
    }

    public List<Purchase> queryPurchasesInApp() {
        return this.b("inapp");
    }

    public List<Purchase> queryPurchasesSubs() {
        return this.b("subs");
    }

    private List<Purchase> b(String string) {
        this.d("[queryPurchases] " + string);
        if (this.g == null) {
            this.d("SDK unavailable, BillingClient is null!");
            return null;
        }
        if (!this.g.isReady()) {
            this.a();
        } else {
            Purchase.PurchasesResult purchasesResult = this.g.queryPurchases(string);
            if (purchasesResult != null && purchasesResult.getResponseCode() == 0) {
                List list = purchasesResult.getPurchasesList();
                if (list != null) {
                    this.d("[queryPurchases] size= " + list.size());
                    for (Purchase purchase : list) {
                        this.a(purchase);
                    }
                } else {
                    this.d("[queryPurchases] size is " + (list != null ? Integer.valueOf(list.size()) : null));
                }
                return list;
            }
        }
        return null;
    }

    public void queryHistoryInApp() {
        this.c("inapp");
    }

    public void queryHistorySubs() {
        this.c("subs");
    }

    private void c(final String string) {
        this.d("[queryPurchaseHistoryAsync] " + string);
        if (this.g == null) {
            this.d("SDK unavailable, BillingClient is null!");
            return;
        }
        if (!this.g.isReady()) {
            this.a();
        } else {
            this.g.queryPurchaseHistoryAsync(string, new PurchaseHistoryResponseListener(){

                public void onPurchaseHistoryResponse(BillingResult billingResult, List<PurchaseHistoryRecord> list) {
                    ArrayList<Purchase> arrayList = null;
                    int n = billingResult.getResponseCode();
                    if (n == 0 && list != null) {
                        arrayList = new ArrayList<Purchase>();
                        for (PurchaseHistoryRecord purchaseHistoryRecord : list) {
                            try {
                                Purchase purchase = new Purchase(purchaseHistoryRecord.getOriginalJson(), purchaseHistoryRecord.getSignature());
                                arrayList.add(purchase);
                                GoogleBillingUtil.this.d("[queryPurchaseHistoryAsync] OrderId: " + purchase.getOrderId() + "\nPackageName:" + purchase.getPackageName() + "\nPurchaseTime:" + purchase.getPurchaseTime() + "\nPurchaseToken:" + purchase.getPurchaseToken() + "\nSku:" + purchase.getSku());
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                            }
                        }
                    }
                    if (GoogleBillingUtil.this.l != null) {
                        GoogleBillingUtil.this.l.onPurchaseHistoryResponse(string, n, arrayList);
                    }
                }
            });
        }
    }

    public int getPurchasesSizeSubs() {
        List<Purchase> list = this.queryPurchasesSubs();
        if (list != null) {
            return list.size();
        }
        return -1;
    }

    public int getSubsPositionBySku(String string) {
        return this.a(string, "subs");
    }

    public int getInAppPositionBySku(String string) {
        return this.a(string, "inapp");
    }

    private int a(String string, String string2) {
        block5: {
            block4: {
                if (!string2.equals("inapp")) break block4;
                int n = 0;
                for (String string3 : this.e) {
                    if (string3.equals(string)) {
                        return n;
                    }
                    ++n;
                }
                break block5;
            }
            if (!string2.equals("subs")) break block5;
            int n = 0;
            for (String string4 : this.f) {
                if (string4.equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private void a(Runnable runnable) {
        if (this.a()) {
            runnable.run();
        }
    }

    public String getSubsSkuByPosition(int n) {
        if (n >= 0 && this.f != null && n < this.f.size()) {
            return this.f.get(n);
        }
        return null;
    }

    public String getInAppSkuByPosition(int n) {
        if (n >= 0 && this.e != null && n < this.e.size()) {
            return this.e.get(n);
        }
        return null;
    }

    public String getSkuType(String string) {
        if (this.e != null && this.e.contains(string)) {
            return "inapp";
        }
        if (this.f != null && this.f.contains(string)) {
            return "subs";
        }
        return null;
    }

    public SkuDetails getSkuDetail(String string) {
        if (this.b == null) {
            return null;
        }
        try {
            return this.b.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void queryUnConsumeOrders(Context context) {
        block2: {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("packageName", (Object)context.getPackageName());
                jSONObject.put("platform", (Object)com.yifants.sdk.purchase.a.b.a);
                jSONObject.put("gaid", (Object)com.yifants.sdk.purchase.a.b.f);
                jSONObject.put("appVersion", (Object)com.yifants.sdk.purchase.a.b.h);
                jSONObject.put("sdkVersion", (Object)this.getVersion());
                String string = jSONObject.toString();
                this.d("queryUnConsumeOrders request: " + string);
                string = com.yifants.sdk.purchase.c.a.a(string);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("sign", (Object)string);
                com.yifants.sdk.purchase.d.c.a(com.yifants.sdk.purchase.c.a.b(com.yifants.sdk.purchase.a.b.l), jSONObject2.toString(), new com.yifants.sdk.purchase.d.a(){

                    @Override
                    public void onResponse(e e2) {
                        block9: {
                            try {
                                String string = new String(e2.c, "utf-8");
                                string = com.yifants.sdk.purchase.c.a.b(string);
                                JSONObject jSONObject = new JSONObject(string);
                                int n = jSONObject.optInt("code");
                                if (n == 200) {
                                    JSONArray jSONArray = jSONObject.optJSONArray("data");
                                    if (jSONArray != null && jSONArray.length() > 0) {
                                        ArrayList<GooglePurchase> arrayList = new ArrayList<GooglePurchase>(jSONArray.length());
                                        for (int i = 0; i < jSONArray.length(); ++i) {
                                            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                                            if (jSONObject2 == null) continue;
                                            GooglePurchase googlePurchase = new GooglePurchase();
                                            arrayList.add(googlePurchase);
                                            googlePurchase.orderId = jSONObject2.optString("orderId");
                                            googlePurchase.productId = jSONObject2.optString("productId");
                                            googlePurchase.purchaseTime = jSONObject2.optLong("purchaseTimeMillis");
                                            googlePurchase.purchaseToken = jSONObject2.optString("purchaseToken");
                                            googlePurchase.billingResponse = jSONObject2.optInt("billingResponse", 0);
                                            googlePurchase.purchaseState = jSONObject2.optInt("purchaseState", 0);
                                            googlePurchase.consumptionState = jSONObject2.optInt("consumptionState", 0);
                                        }
                                        if (GoogleBillingUtil.this.k != null) {
                                            GoogleBillingUtil.this.k.onQueryUnConsumeSuccess(n, arrayList);
                                        }
                                        return;
                                    }
                                    if (GoogleBillingUtil.this.k != null) {
                                        GoogleBillingUtil.this.k.onQueryUnConsumeSuccess(n, null);
                                    }
                                } else if (GoogleBillingUtil.this.k != null) {
                                    GoogleBillingUtil.this.k.onQueryUnConsumeFail(n, jSONObject.optString("msg"));
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (GoogleBillingUtil.this.k == null) break block9;
                                GoogleBillingUtil.this.k.onQueryUnConsumeFail(203, "response data error");
                            }
                        }
                    }

                    @Override
                    public void onFailure(d d2, IOException iOException) {
                        GoogleBillingUtil.this.d("[onFailure]: " + iOException.getMessage());
                        if (GoogleBillingUtil.this.k != null) {
                            GoogleBillingUtil.this.k.onQueryUnConsumeFail(204, iOException.getMessage());
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.k == null) break block2;
                this.k.onQueryUnConsumeFail(205, "request failed");
            }
        }
    }

    public void isValidSubscription(String string, String string2, OnQuerySubValidListener onQuerySubValidListener) {
        this.a(string, string2, onQuerySubValidListener, true);
    }

    private void a(final @NonNull String string, final @NonNull String string2, final @NonNull OnQuerySubValidListener onQuerySubValidListener, final boolean bl) {
        block12: {
            if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                if (onQuerySubValidListener != null) {
                    onQuerySubValidListener.onQuerySubValidFail(string, 304, "subSKU or purchaseToken is null");
                }
                return;
            }
            try {
                String string3;
                Object object;
                Object object2;
                final boolean bl2 = this.a;
                boolean bl3 = true;
                final String string4 = "isValidSubscription_" + string;
                final String string5 = this.d.format(new Date());
                if (!bl2 && this.q != null) {
                    try {
                        object2 = com.yifants.sdk.purchase.a.a.a(this.q).a(string4);
                        if (!TextUtils.isEmpty((CharSequence)object2) && (object = ((String)object2).split("00_oo")) != null && ((String[])object).length == 2 && string5.equals(object[0])) {
                            this.d("[isValidSubscription] use today local cache --------------");
                            string3 = object[1];
                            this.d("[isValidSubscription] local cache responseJson==>" + string3);
                            JSONObject jSONObject = new JSONObject(string3);
                            int n = jSONObject.optInt("code");
                            if (n == 200) {
                                GooglePurchase googlePurchase = new GooglePurchase();
                                googlePurchase.skuType = "subs";
                                googlePurchase.productId = string;
                                googlePurchase.purchaseToken = string2;
                                JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                                if (jSONObject2 != null) {
                                    googlePurchase.orderId = jSONObject2.optString("orderId");
                                    googlePurchase.startTimeMillis = jSONObject2.optLong("startTimeMillis");
                                    googlePurchase.expiryTimeMillis = jSONObject2.optLong("expiryTimeMillis");
                                    googlePurchase.serverTimeMillis = jSONObject2.optLong("serverTimeMillis");
                                    googlePurchase.subPaymentState = jSONObject2.optInt("paymentState");
                                    googlePurchase.purchaseState = jSONObject2.optInt("purchaseState", 0);
                                    googlePurchase.autoRenewing = jSONObject2.optBoolean("autoRenewing");
                                }
                                if (onQuerySubValidListener != null) {
                                    onQuerySubValidListener.onQuerySubValidFinish(googlePurchase);
                                }
                                bl3 = false;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl3) {
                    return;
                }
                object2 = new JSONObject();
                object2.put("subscriptionId", (Object)string);
                object2.put("purchaseToken", (Object)string2);
                object2.put("packageName", (Object)com.yifants.sdk.purchase.a.b.g);
                object2.put("appVersion", (Object)com.yifants.sdk.purchase.a.b.h);
                object2.put("sdkVersion", (Object)this.getVersion());
                object = object2.toString();
                this.d("[isValidSubscription] request: " + (String)object);
                object = com.yifants.sdk.purchase.c.a.a((String)object);
                string3 = new JSONObject();
                string3.put("sign", object);
                com.yifants.sdk.purchase.d.c.a(com.yifants.sdk.purchase.a.b.n, string3.toString(), new com.yifants.sdk.purchase.d.a(){

                    @Override
                    public void onResponse(e e2) {
                        block10: {
                            try {
                                String string3 = new String(e2.c, "utf-8");
                                string3 = com.yifants.sdk.purchase.c.a.b(string3);
                                GoogleBillingUtil.this.d("[isValidSubscription] respContent aesDecrypt==>" + string3);
                                JSONObject jSONObject = new JSONObject(string3);
                                int n = jSONObject.optInt("code");
                                if (n == 200) {
                                    GooglePurchase googlePurchase = new GooglePurchase();
                                    googlePurchase.skuType = "subs";
                                    googlePurchase.productId = string;
                                    googlePurchase.purchaseToken = string2;
                                    JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                                    if (jSONObject2 != null) {
                                        googlePurchase.orderId = jSONObject2.optString("orderId");
                                        googlePurchase.startTimeMillis = jSONObject2.optLong("startTimeMillis");
                                        googlePurchase.expiryTimeMillis = jSONObject2.optLong("expiryTimeMillis");
                                        googlePurchase.serverTimeMillis = jSONObject2.optLong("serverTimeMillis");
                                        googlePurchase.subPaymentState = jSONObject2.optInt("paymentState");
                                        googlePurchase.purchaseState = jSONObject2.optInt("purchaseState", 0);
                                        googlePurchase.autoRenewing = jSONObject2.optBoolean("autoRenewing");
                                    }
                                    if (onQuerySubValidListener != null) {
                                        onQuerySubValidListener.onQuerySubValidFinish(googlePurchase);
                                    }
                                    if (!bl2 && googlePurchase.isValidSub() && !TextUtils.isEmpty((CharSequence)googlePurchase.orderId)) {
                                        com.yifants.sdk.purchase.a.a.a(GoogleBillingUtil.this.q).a(string4, string5 + "00_oo" + string3);
                                    }
                                } else if (n == 100 && bl) {
                                    new Thread(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                Thread.sleep(4000L);
                                                GoogleBillingUtil.this.a(string, string2, onQuerySubValidListener, false);
                                                GoogleBillingUtil.this.d("[isValidSubscription] \u91cd\u8bd5\u8ba2\u9605\u67e5\u8be2\u8bf7\u6c42");
                                            }
                                            catch (InterruptedException interruptedException) {
                                                interruptedException.printStackTrace();
                                            }
                                        }
                                    }).start();
                                } else if (onQuerySubValidListener != null) {
                                    onQuerySubValidListener.onQuerySubValidFail(string, n, jSONObject.optString("msg"));
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                if (onQuerySubValidListener == null) break block10;
                                onQuerySubValidListener.onQuerySubValidFail(string, 203, "response data error");
                            }
                        }
                    }

                    @Override
                    public void onFailure(d d2, IOException iOException) {
                        GoogleBillingUtil.this.d("[onFailure]: " + iOException.getMessage());
                        if (onQuerySubValidListener != null) {
                            onQuerySubValidListener.onQuerySubValidFail(string, 204, iOException.getMessage());
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (onQuerySubValidListener == null) break block12;
                onQuerySubValidListener.onQuerySubValidFail(string, 205, "request failed");
            }
        }
    }

    public GoogleBillingUtil setOnQueryFinishedListener(OnQueryFinishedListener onQueryFinishedListener) {
        this.m = onQueryFinishedListener;
        return r;
    }

    public GoogleBillingUtil setOnPurchaseFinishedListener(OnPurchaseFinishedListener onPurchaseFinishedListener) {
        this.i = onPurchaseFinishedListener;
        return r;
    }

    public GoogleBillingUtil setOnConsumeFinishedListener(OnConsumeFinishedListener onConsumeFinishedListener) {
        this.n = onConsumeFinishedListener;
        return r;
    }

    public GoogleBillingUtil setOnStartSetupFinishedListener(OnStartSetupFinishedListener onStartSetupFinishedListener) {
        this.j = onStartSetupFinishedListener;
        return r;
    }

    public GoogleBillingUtil setOnQueryUnConsumeOrderListener(OnQueryUnConsumeOrderListener onQueryUnConsumeOrderListener) {
        this.k = onQueryUnConsumeOrderListener;
        return r;
    }

    public GoogleBillingUtil setOnQueryHistoryQurchaseListener(OnQueryHistoryQurchaseListener onQueryHistoryQurchaseListener) {
        this.l = onQueryHistoryQurchaseListener;
        return r;
    }

    public GoogleBillingUtil setDebugAble(boolean bl) {
        this.a = bl;
        return r;
    }

    public GoogleBillingUtil setInAppSKUS(String[] stringArray) {
        this.e = Arrays.asList(stringArray);
        return r;
    }

    public GoogleBillingUtil setSubsSKUS(String[] stringArray) {
        this.f = Arrays.asList(stringArray);
        return r;
    }

    public GoogleBillingUtil setAutoConsumeAsync(boolean bl) {
        this.o = bl;
        return r;
    }

    public GoogleBillingUtil setAutoVerifyPurchase(VerifyPurchaseUtil verifyPurchaseUtil) {
        this.p = verifyPurchaseUtil;
        return r;
    }

    public boolean isReady() {
        return this.g != null && this.g.isReady();
    }

    public boolean isAutoConsumeAsync() {
        return this.o;
    }

    private void d(String string) {
        if (this.a) {
            Log.i((String)"SDK_YiFans_Billing", (String)string);
        }
    }

    public static interface OnStartSetupFinishedListener {
        public void onSetupSuccess();

        public void onSetupFail(int var1);

        public void onSetupError();
    }

    public static interface OnQueryHistoryQurchaseListener {
        public void onPurchaseHistoryResponse(String var1, int var2, List<Purchase> var3);
    }

    public static interface OnQueryUnConsumeOrderListener {
        public void onQueryUnConsumeSuccess(int var1, List<GooglePurchase> var2);

        public void onQueryUnConsumeFail(int var1, String var2);
    }

    public static interface OnConsumeFinishedListener {
        public void onConsumeSuccess(String var1);

        public void onConsumeFail(int var1, String var2);
    }

    public static interface OnQuerySubValidListener {
        public void onQuerySubValidFinish(GooglePurchase var1);

        public void onQuerySubValidFail(String var1, int var2, String var3);
    }

    public static interface OnPurchaseFinishedListener {
        public void onPurchaseCompleted(int var1, Purchase var2);

        public void onPurchasePending(int var1, Purchase var2);

        public void onPurchaseCanceled(int var1, List<Purchase> var2);

        public void onPurchaseFailed(int var1, List<Purchase> var2);

        public void onPurchaseError(String var1);
    }

    public static interface OnQueryFinishedListener {
        public void onQuerySuccess(String var1, List<SkuDetails> var2);

        public void onQueryFail(int var1, String var2, List<SkuDetails> var3);

        public void onQueryError();
    }

    private class MyConsumeResponseListener
    implements ConsumeResponseListener {
        private MyConsumeResponseListener() {
        }

        public void onConsumeResponse(BillingResult billingResult, String string) {
            if (GoogleBillingUtil.this.n == null) {
                if (GoogleBillingUtil.this.a) {
                    GoogleBillingUtil.this.d("\u8b66\u544a:\u63a5\u6536\u5230\u6d88\u8017\u5546\u54c1\u56de\u8c03\uff0c\u4f46\u6d88\u8017\u5546\u54c1\u63a5\u53e3\u4e3aNull\uff0c\u8bf7\u8bbe\u7f6e\u6d88\u8017\u5546\u54c1\u56de\u8c03\u63a5\u53e3\u3002eg:setOnConsumeFinishedListener()");
                }
                return;
            }
            int n = billingResult.getResponseCode();
            if (n == 0) {
                GoogleBillingUtil.this.n.onConsumeSuccess(string);
            } else {
                GoogleBillingUtil.this.n.onConsumeFail(n, string);
            }
        }
    }

    private class MySkuDetailsResponseListener
    implements SkuDetailsResponseListener {
        private OnQueryFinishedListener mOnQueryFinishedListener;
        private String skuType;

        public MySkuDetailsResponseListener(OnQueryFinishedListener onQueryFinishedListener, String string) {
            this.mOnQueryFinishedListener = onQueryFinishedListener;
            this.skuType = string;
        }

        public void onSkuDetailsResponse(BillingResult billingResult, List<SkuDetails> list) {
            int n = billingResult.getResponseCode();
            try {
                if (GoogleBillingUtil.this.b == null) {
                    GoogleBillingUtil.this.b = new HashMap();
                }
                if (list != null) {
                    for (SkuDetails skuDetails : list) {
                        if (GoogleBillingUtil.this.b.containsKey(skuDetails.getSku())) continue;
                        GoogleBillingUtil.this.b.put(skuDetails.getSku(), skuDetails);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.mOnQueryFinishedListener == null) {
                if (GoogleBillingUtil.this.a) {
                    GoogleBillingUtil.this.d("\u8b66\u544a:\u63a5\u6536\u5230\u67e5\u8be2\u5546\u54c1\u56de\u8c03\uff0c\u4f46\u67e5\u8be2\u5546\u54c1\u63a5\u53e3\u4e3aNull\uff0c\u8bf7\u8bbe\u7f6e\u8d2d\u4e70\u63a5\u53e3\u3002eg:setOnQueryFinishedListener()");
                }
                return;
            }
            if (n == 0 && list != null) {
                this.mOnQueryFinishedListener.onQuerySuccess(this.skuType, list);
            } else {
                GoogleBillingUtil.this.d(n + "\n" + billingResult.getDebugMessage());
                this.mOnQueryFinishedListener.onQueryFail(n, this.skuType, list);
            }
        }
    }

    private class MyPurchasesUpdatedListener
    implements PurchasesUpdatedListener {
        private MyPurchasesUpdatedListener() {
        }

        public void onPurchasesUpdated(BillingResult billingResult, @Nullable List<Purchase> list) {
            if (GoogleBillingUtil.this.i == null) {
                if (GoogleBillingUtil.this.a) {
                    GoogleBillingUtil.this.d("\u8b66\u544a:\u63a5\u6536\u5230\u8d2d\u4e70\u56de\u8c03\uff0c\u4f46\u8d2d\u4e70\u5546\u54c1\u63a5\u53e3\u4e3aNull\uff0c\u8bf7\u8bbe\u7f6e\u8d2d\u4e70\u63a5\u53e3\u3002eg:setOnPurchaseFinishedListener()");
                }
                return;
            }
            int n = billingResult.getResponseCode();
            if (n == 0 && list != null) {
                for (Purchase purchase : list) {
                    if (purchase.getPurchaseState() == 1) {
                        GoogleBillingUtil.this.a(purchase);
                        GoogleBillingUtil.this.i.onPurchaseCompleted(n, purchase);
                        if (GoogleBillingUtil.this.p == null || purchase == null) continue;
                        if (GoogleBillingUtil.this.a) {
                            GoogleBillingUtil.this.d("onPurchaseCompleted -> AutoVerifyPurchase");
                        }
                        GoogleBillingUtil.this.p.verifyPurchase(n, purchase);
                        continue;
                    }
                    if (purchase.getPurchaseState() != 2) continue;
                    GoogleBillingUtil.this.i.onPurchasePending(n, purchase);
                    if (GoogleBillingUtil.this.p == null || purchase == null) continue;
                    if (GoogleBillingUtil.this.a) {
                        GoogleBillingUtil.this.d("onPurchasePending -> AutoVerifyPurchase");
                    }
                    GoogleBillingUtil.this.p.verifyPurchase(n, purchase);
                }
            } else if (n == 1) {
                GoogleBillingUtil.this.i.onPurchaseCanceled(n, list);
                if (GoogleBillingUtil.this.p != null && list != null) {
                    if (GoogleBillingUtil.this.a) {
                        GoogleBillingUtil.this.d("onPurchaseCanceled -> AutoVerifyPurchase");
                    }
                    GoogleBillingUtil.this.p.verifyPurchase(n, list);
                }
            } else {
                GoogleBillingUtil.this.i.onPurchaseFailed(n, list);
                if (GoogleBillingUtil.this.p != null && list != null) {
                    if (GoogleBillingUtil.this.a) {
                        GoogleBillingUtil.this.d("onPurchaseFailed -> AutoVerifyPurchase");
                    }
                    GoogleBillingUtil.this.p.verifyPurchase(n, list);
                }
            }
        }
    }
}

