/*
 * Decompiled with CFR 0.152.
 */
package com.common.util;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.common.util.IabBroadcastReceiver;
import com.common.util.IabHelper;
import com.common.util.IabResult;
import com.common.util.Inventory;
import com.common.util.Purchase;

public class GooglePlayBillingUtil {
    static final String TAG = "GooglePlayBillingUtil";
    static final String SKU_PREMIUM = "premium";
    static final String SKU_GAS = "gas";
    boolean mAutoRenewEnabled = false;
    String mInfiniteGasSku = "";
    static final String SKU_INFINITE_GAS = "infinite_gas";
    static final String SKU_INFINITE_GAS_MONTHLY = "infinite_gas_monthly";
    static final String SKU_INFINITE_GAS_YEARLY = "infinite_gas_yearly";
    boolean mSubscribedToInfiniteGas = false;
    static final int TANK_MAX = 4;
    int mTank;
    static final int RC_REQUEST = 13001;
    boolean mIsPremium = false;
    IabHelper mHelper;
    String skus;
    Activity currentActivity;
    private static GooglePlayBillingUtil sInstance;
    public static PurchaseFinishedListener purchaseFinishedListener;
    IabBroadcastReceiver mBroadcastReceiver;
    boolean iabInstall = false;
    IabHelper.OnIabPurchaseFinishedListener mPurchaseFinishedListener = new IabHelper.OnIabPurchaseFinishedListener(){

        @Override
        public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
            Log.d((String)GooglePlayBillingUtil.TAG, (String)("Purchase finished: " + result + ", purchase: " + purchase));
            if (GooglePlayBillingUtil.this.mHelper == null) {
                return;
            }
            if (result.isFailure()) {
                GooglePlayBillingUtil.this.complain("Error purchasing: " + result);
                GooglePlayBillingUtil.this.buying = false;
                return;
            }
            if (!GooglePlayBillingUtil.this.verifyDeveloperPayload(purchase)) {
                GooglePlayBillingUtil.this.complain("Error purchasing. Authenticity verification failed.");
                GooglePlayBillingUtil.this.buying = false;
                return;
            }
            Log.d((String)GooglePlayBillingUtil.TAG, (String)"Purchase successful.");
            if (purchase.getSku().equals(GooglePlayBillingUtil.SKU_GAS)) {
                Log.d((String)GooglePlayBillingUtil.TAG, (String)"Purchase is gas. Starting gas consumption.");
                try {
                    GooglePlayBillingUtil.this.mHelper.consumeAsync(purchase, GooglePlayBillingUtil.this.mConsumeFinishedListener);
                }
                catch (IabHelper.IabAsyncInProgressException e) {
                    GooglePlayBillingUtil.this.complain("Error consuming gas. Another async operation in progress.");
                    GooglePlayBillingUtil.this.buying = false;
                    return;
                }
            }
            if (purchase.getSku().equals(GooglePlayBillingUtil.SKU_PREMIUM)) {
                Log.d((String)GooglePlayBillingUtil.TAG, (String)"Purchase is premium upgrade. Congratulating user.");
                GooglePlayBillingUtil.this.mIsPremium = true;
                GooglePlayBillingUtil.this.buying = false;
            } else if (purchase.getSku().equals(GooglePlayBillingUtil.SKU_INFINITE_GAS_MONTHLY) || purchase.getSku().equals(GooglePlayBillingUtil.SKU_INFINITE_GAS_YEARLY)) {
                Log.d((String)GooglePlayBillingUtil.TAG, (String)"Infinite gas subscription purchased.");
                GooglePlayBillingUtil.this.alert("Thank you for subscribing to infinite gas!");
                GooglePlayBillingUtil.this.mSubscribedToInfiniteGas = true;
                GooglePlayBillingUtil.this.mAutoRenewEnabled = purchase.isAutoRenewing();
                GooglePlayBillingUtil.this.mInfiniteGasSku = purchase.getSku();
                GooglePlayBillingUtil.this.buying = false;
            } else if (purchase.getSku().equals(GooglePlayBillingUtil.this.sku)) {
                Log.d((String)GooglePlayBillingUtil.TAG, (String)(GooglePlayBillingUtil.this.sku + ". Starting gas consumption."));
                try {
                    GooglePlayBillingUtil.this.mHelper.consumeAsync(purchase, GooglePlayBillingUtil.this.mConsumeFinishedListener);
                }
                catch (IabHelper.IabAsyncInProgressException e) {
                    GooglePlayBillingUtil.this.complain("Error consuming gas. Another async operation in progress.");
                }
            }
        }
    };
    String sku = "";
    boolean buying = false;
    IabHelper.QueryInventoryFinishedListener mGotInventoryListener = new IabHelper.QueryInventoryFinishedListener(){

        @Override
        public void onQueryInventoryFinished(IabResult result, Inventory inventory) {
            Purchase gasPurchase;
            Log.d((String)GooglePlayBillingUtil.TAG, (String)"Query inventory finished.");
            if (GooglePlayBillingUtil.this.mHelper == null) {
                return;
            }
            if (result.isFailure()) {
                GooglePlayBillingUtil.this.complain("Failed to query inventory: " + result);
                return;
            }
            Log.d((String)GooglePlayBillingUtil.TAG, (String)"Query inventory was successful.");
            Purchase premiumPurchase = inventory.getPurchase(GooglePlayBillingUtil.SKU_PREMIUM);
            GooglePlayBillingUtil.this.mIsPremium = premiumPurchase != null && GooglePlayBillingUtil.this.verifyDeveloperPayload(premiumPurchase);
            Log.d((String)GooglePlayBillingUtil.TAG, (String)("User is " + (GooglePlayBillingUtil.this.mIsPremium ? "PREMIUM" : "NOT PREMIUM")));
            Purchase infiniteGasPurchase = inventory.getPurchase(GooglePlayBillingUtil.SKU_INFINITE_GAS);
            GooglePlayBillingUtil.this.mSubscribedToInfiniteGas = infiniteGasPurchase != null && GooglePlayBillingUtil.this.verifyDeveloperPayload(infiniteGasPurchase);
            Log.d((String)GooglePlayBillingUtil.TAG, (String)("User " + (GooglePlayBillingUtil.this.mSubscribedToInfiniteGas ? "HAS" : "DOES NOT HAVE") + " infinite gas subscription."));
            if (GooglePlayBillingUtil.this.mSubscribedToInfiniteGas) {
                GooglePlayBillingUtil.this.mTank = 4;
            }
            if ((gasPurchase = inventory.getPurchase(GooglePlayBillingUtil.SKU_GAS)) != null && GooglePlayBillingUtil.this.verifyDeveloperPayload(gasPurchase)) {
                Log.d((String)GooglePlayBillingUtil.TAG, (String)"We have gas. Consuming it.");
                try {
                    GooglePlayBillingUtil.this.mHelper.consumeAsync(inventory.getPurchase(GooglePlayBillingUtil.SKU_GAS), GooglePlayBillingUtil.this.mConsumeFinishedListener);
                }
                catch (IabHelper.IabAsyncInProgressException e) {
                    GooglePlayBillingUtil.this.complain("Error consuming gas. Another async operation in progress.");
                }
                return;
            }
            if (GooglePlayBillingUtil.this.skus != null) {
                String[] skuids = GooglePlayBillingUtil.this.skus.split(",");
                for (int i = 0; i < skuids.length; ++i) {
                    gasPurchase = inventory.getPurchase(skuids[i]);
                    if (gasPurchase == null || !GooglePlayBillingUtil.this.verifyDeveloperPayload(gasPurchase)) continue;
                    try {
                        GooglePlayBillingUtil.this.mHelper.consumeAsync(gasPurchase, GooglePlayBillingUtil.this.mConsumeFinishedListener);
                        continue;
                    }
                    catch (IabHelper.IabAsyncInProgressException e) {
                        GooglePlayBillingUtil.this.complain("Error consuming gas. Another async operation in progress.");
                    }
                }
                GooglePlayBillingUtil.this.skus = null;
            }
            Log.d((String)GooglePlayBillingUtil.TAG, (String)"Initial inventory query finished; enabling main UI.");
        }
    };
    IabHelper.OnConsumeFinishedListener mConsumeFinishedListener = new IabHelper.OnConsumeFinishedListener(){

        @Override
        public void onConsumeFinished(Purchase purchase, IabResult result) {
            Log.d((String)GooglePlayBillingUtil.TAG, (String)("Consumption finished. Purchase: " + purchase + ", result: " + result));
            if (GooglePlayBillingUtil.this.mHelper == null) {
                return;
            }
            if (result.isSuccess()) {
                Log.d((String)GooglePlayBillingUtil.TAG, (String)("Consumption successful. Provisioning." + purchase.getSku()));
                GooglePlayBillingUtil.this.mTank = GooglePlayBillingUtil.this.mTank == 4 ? 4 : GooglePlayBillingUtil.this.mTank + 1;
                String sku = purchase.getSku();
                if (purchaseFinishedListener != null) {
                    purchaseFinishedListener.paySuccess(sku);
                }
            } else {
                GooglePlayBillingUtil.this.complain("Error while consuming: " + result);
            }
            GooglePlayBillingUtil.this.buying = false;
            Log.d((String)GooglePlayBillingUtil.TAG, (String)"End consumption flow.");
        }
    };

    public static GooglePlayBillingUtil getInstance() {
        if (sInstance == null) {
            sInstance = new GooglePlayBillingUtil();
        }
        return sInstance;
    }

    public void init(Activity activity, String base64EncodedPublicKey, String skus) {
        this.init(activity, base64EncodedPublicKey, skus, null);
    }

    public void init(Activity activity, String base64EncodedPublicKey, String skus, PurchaseFinishedListener purchaseFinishedListener) {
        this.currentActivity = activity;
        this.mHelper = new IabHelper((Context)this.currentActivity, base64EncodedPublicKey);
        this.mHelper.enableDebugLogging(true);
        GooglePlayBillingUtil.purchaseFinishedListener = purchaseFinishedListener;
        this.skus = skus;
        Log.d((String)TAG, (String)"Starting setup.");
        this.mHelper.startSetup(new IabHelper.OnIabSetupFinishedListener(){

            @Override
            public void onIabSetupFinished(IabResult result) {
                Log.d((String)GooglePlayBillingUtil.TAG, (String)"Setup finished.");
                if (!result.isSuccess()) {
                    GooglePlayBillingUtil.this.complain("Problem setting up in-app billing: " + result);
                    return;
                }
                if (GooglePlayBillingUtil.this.mHelper == null) {
                    return;
                }
                GooglePlayBillingUtil.this.iabInstall = true;
                GooglePlayBillingUtil.this.mBroadcastReceiver = new IabBroadcastReceiver(new IabBroadcastReceiver.IabBroadcastListener(){

                    @Override
                    public void receivedBroadcast() {
                        Log.d((String)GooglePlayBillingUtil.TAG, (String)"Received broadcast notification. Querying inventory.");
                        try {
                            GooglePlayBillingUtil.this.mHelper.queryInventoryAsync(GooglePlayBillingUtil.this.mGotInventoryListener);
                        }
                        catch (IabHelper.IabAsyncInProgressException e) {
                            GooglePlayBillingUtil.this.complain("Error querying inventory. Another async operation in progress.");
                        }
                    }
                });
                IntentFilter broadcastFilter = new IntentFilter("com.android.vending.billing.PURCHASES_UPDATED");
                GooglePlayBillingUtil.this.currentActivity.registerReceiver((BroadcastReceiver)GooglePlayBillingUtil.this.mBroadcastReceiver, broadcastFilter);
                Log.d((String)GooglePlayBillingUtil.TAG, (String)"Setup successful. Querying inventory.");
                try {
                    GooglePlayBillingUtil.this.mHelper.queryInventoryAsync(GooglePlayBillingUtil.this.mGotInventoryListener);
                }
                catch (IabHelper.IabAsyncInProgressException e) {
                    GooglePlayBillingUtil.this.complain("Error querying inventory. Another async operation in progress.");
                }
            }
        });
    }

    public void callLaunchPurchaseFlow(String skuID) {
        if (this.buying) {
            return;
        }
        this.sku = skuID;
        this.buying = true;
        String payload = "";
        if (this.iabInstall) {
            try {
                this.mHelper.launchPurchaseFlow(this.currentActivity, this.sku, 13001, this.mPurchaseFinishedListener, payload);
            }
            catch (IabHelper.IabAsyncInProgressException e) {
                this.complain("Error launching purchase flow. Another async operation in progress.");
            }
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)TAG, (String)("onActivityResult(" + requestCode + "," + resultCode + "," + data));
        if (this.mHelper == null) {
            return true;
        }
        return this.mHelper.handleActivityResult(requestCode, resultCode, data);
    }

    void complain(String message) {
        Log.e((String)TAG, (String)("**** TrivialDrive Error: " + message));
    }

    void alert(String message) {
        AlertDialog.Builder bld = new AlertDialog.Builder((Context)this.currentActivity);
        bld.setMessage((CharSequence)message);
        bld.setNeutralButton((CharSequence)"OK", null);
        Log.d((String)TAG, (String)("Showing alert dialog: " + message));
        bld.create().show();
    }

    boolean verifyDeveloperPayload(Purchase p) {
        String payload = p.getDeveloperPayload();
        return true;
    }

    public void onDestroy() {
        if (this.mBroadcastReceiver != null && this.currentActivity != null) {
            this.currentActivity.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        }
        Log.d((String)TAG, (String)"Destroying helper.");
        if (this.mHelper != null) {
            this.mHelper.disposeWhenFinished();
            this.mHelper = null;
        }
    }

    public static interface PurchaseFinishedListener {
        public void paySuccess(String var1);
    }
}

