/*
 * Decompiled with CFR 0.152.
 */
package com.common.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class GameHelperUtils {
    public static final int R_UNKNOWN_ERROR = 0;
    public static final int R_SIGN_IN_FAILED = 1;
    public static final int R_APP_MISCONFIGURED = 2;
    public static final int R_LICENSE_FAILED = 3;
    private static final String[] FALLBACK_STRINGS = new String[]{"*Unknown error.", "*Failed to sign in. Please check your network connection and try again.", "*The application is incorrectly configured. Check that the package name and signing certificate match the client ID created in Developer Console. Also, if the application is not yet published, check that the account you are trying to sign in with is listed as a tester account. See logs for more information.", "*License check failed."};

    GameHelperUtils() {
    }

    static String activityResponseCodeToString(int respCode) {
        switch (respCode) {
            case -1: {
                return "RESULT_OK";
            }
            case 0: {
                return "RESULT_CANCELED";
            }
            case 10004: {
                return "RESULT_APP_MISCONFIGURED";
            }
            case 10005: {
                return "RESULT_LEFT_ROOM";
            }
            case 10003: {
                return "RESULT_LICENSE_FAILED";
            }
            case 10001: {
                return "RESULT_RECONNECT_REQUIRED";
            }
            case 10002: {
                return "SIGN_IN_FAILED";
            }
        }
        return String.valueOf(respCode);
    }

    static String errorCodeToString(int errorCode) {
        switch (errorCode) {
            case 10: {
                return "DEVELOPER_ERROR(" + errorCode + ")";
            }
            case 8: {
                return "INTERNAL_ERROR(" + errorCode + ")";
            }
            case 5: {
                return "INVALID_ACCOUNT(" + errorCode + ")";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED(" + errorCode + ")";
            }
            case 7: {
                return "NETWORK_ERROR(" + errorCode + ")";
            }
            case 6: {
                return "RESOLUTION_REQUIRED(" + errorCode + ")";
            }
            case 3: {
                return "SERVICE_DISABLED(" + errorCode + ")";
            }
            case 9: {
                return "SERVICE_INVALID(" + errorCode + ")";
            }
            case 1: {
                return "SERVICE_MISSING(" + errorCode + ")";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED(" + errorCode + ")";
            }
            case 4: {
                return "SIGN_IN_REQUIRED(" + errorCode + ")";
            }
            case 0: {
                return "SUCCESS(" + errorCode + ")";
            }
        }
        return "Unknown error code " + errorCode;
    }

    static void printMisconfiguredDebugInfo(Context ctx) {
        Log.w((String)"GameHelper", (String)"****");
        Log.w((String)"GameHelper", (String)"****");
        Log.w((String)"GameHelper", (String)"**** APP NOT CORRECTLY CONFIGURED TO USE GOOGLE PLAY GAME SERVICES");
        Log.w((String)"GameHelper", (String)"**** This is usually caused by one of these reasons:");
        Log.w((String)"GameHelper", (String)"**** (1) Your package name and certificate fingerprint do not match");
        Log.w((String)"GameHelper", (String)"****     the client ID you registered in Developer Console.");
        Log.w((String)"GameHelper", (String)"**** (2) Your App ID was incorrectly entered.");
        Log.w((String)"GameHelper", (String)"**** (3) Your game settings have not been published and you are ");
        Log.w((String)"GameHelper", (String)"****     trying to log in with an account that is not listed as");
        Log.w((String)"GameHelper", (String)"****     a test account.");
        Log.w((String)"GameHelper", (String)"****");
        if (ctx == null) {
            Log.w((String)"GameHelper", (String)"*** (no Context, so can't print more debug info)");
            return;
        }
        Log.w((String)"GameHelper", (String)"**** To help you debug, here is the information about this app");
        Log.w((String)"GameHelper", (String)("**** Package name         : " + ctx.getPackageName()));
        Log.w((String)"GameHelper", (String)("**** Cert SHA1 fingerprint: " + GameHelperUtils.getSHA1CertFingerprint(ctx)));
        Log.w((String)"GameHelper", (String)("**** App ID from          : " + GameHelperUtils.getAppIdFromResource(ctx)));
        Log.w((String)"GameHelper", (String)"****");
        Log.w((String)"GameHelper", (String)"**** Check that the above information matches your setup in ");
        Log.w((String)"GameHelper", (String)"**** Developer Console. Also, check that you're logging in with the");
        Log.w((String)"GameHelper", (String)"**** right account (it should be listed in the Testers section if");
        Log.w((String)"GameHelper", (String)"**** your project is not yet published).");
        Log.w((String)"GameHelper", (String)"****");
        Log.w((String)"GameHelper", (String)"**** For more information, refer to the troubleshooting guide:");
        Log.w((String)"GameHelper", (String)"****   http://developers.google.com/games/services/android/troubleshooting");
    }

    static String getAppIdFromResource(Context ctx) {
        try {
            Resources res = ctx.getResources();
            String pkgName = ctx.getPackageName();
            int res_id = res.getIdentifier("app_id", "string", pkgName);
            return res.getString(res_id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "??? (failed to retrieve APP ID)";
        }
    }

    static String getSHA1CertFingerprint(Context ctx) {
        try {
            Signature[] sigs = ctx.getPackageManager().getPackageInfo((String)ctx.getPackageName(), (int)64).signatures;
            if (sigs.length == 0) {
                return "ERROR: NO SIGNATURE.";
            }
            if (sigs.length > 1) {
                return "ERROR: MULTIPLE SIGNATURES";
            }
            byte[] digest = MessageDigest.getInstance("SHA1").digest(sigs[0].toByteArray());
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                if (i > 0) {
                    hexString.append(":");
                }
                GameHelperUtils.byteToString(hexString, digest[i]);
            }
            return hexString.toString();
        }
        catch (PackageManager.NameNotFoundException ex) {
            ex.printStackTrace();
            return "(ERROR: package not found)";
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return "(ERROR: SHA1 algorithm not found)";
        }
    }

    static void byteToString(StringBuilder sb, byte b) {
        int unsigned_byte = b < 0 ? b + 256 : b;
        int hi = unsigned_byte / 16;
        int lo = unsigned_byte % 16;
        sb.append("0123456789ABCDEF".substring(hi, hi + 1));
        sb.append("0123456789ABCDEF".substring(lo, lo + 1));
    }

    static String getString(Context ctx, int whichString) {
        whichString = whichString >= 0 && whichString < FALLBACK_STRINGS.length ? whichString : 0;
        return FALLBACK_STRINGS[whichString];
    }
}

