/*
 * Decompiled with CFR 0.152.
 */
package com.yifans.sdk.users;

import android.content.Context;
import android.text.TextUtils;
import com.common.utils.DLog;
import com.common.utils.PlayServicesUtils;
import com.yifans.sdk.users.LoginCallBack;
import com.yifans.sdk.users.STYPE;
import com.yifans.sdk.users.data.CacheHelper;
import com.yifans.sdk.users.data.HttpHelper;
import com.yifans.sdk.users.data.YFUser;

public class YFUserAgent {
    private static String pkg;
    private static String cidfa;

    public static void onApploctionCreated(Context context) {
        pkg = context.getPackageName();
        CacheHelper.init(context);
        PlayServicesUtils.getPlayAdId((Context)context, (PlayServicesUtils.PlayAdIdReadListener)new PlayServicesUtils.PlayAdIdReadListener(){

            public void onPlayAdIdRead(String playAdId) {
                if (!TextUtils.isEmpty((CharSequence)playAdId)) {
                    cidfa = playAdId;
                }
                if (DLog.isDebug()) {
                    DLog.d((String)("[YiFans_YFUser] onApploctionCreated idfa=> " + cidfa));
                }
                YFUserAgent.login(null);
            }
        });
    }

    public static void login(LoginCallBack callBack) {
        YFUserAgent.login(null, callBack);
    }

    public static void login(String userid, LoginCallBack callBack) {
        YFUserAgent.login(userid, null, null, callBack);
    }

    public static void login(final STYPE sType, final String sAccount, final LoginCallBack callBack) {
        YFUser user = YFUserAgent.getCurrentUser();
        if (user == null || TextUtils.isEmpty((CharSequence)user.getUserid())) {
            DLog.e((String)"YiFans_YFUser_[login] userid is null, auto login first !");
            YFUserAgent.login(new LoginCallBack(){

                @Override
                public void onSuccess(YFUser user) {
                    YFUserAgent.login(null, sType, sAccount, callBack);
                }

                @Override
                public void onFailed(int code, String msg) {
                    DLog.e((String)"YiFans_[login] userid is null, auto login first => end onFailed!");
                    if (callBack != null) {
                        callBack.onFailed(409, "userid is null, auto login first => end onFailed!");
                    }
                }
            });
        } else {
            YFUserAgent.login(null, sType, sAccount, callBack);
        }
    }

    private static void login(String old_userid, STYPE sType, String sAccount, LoginCallBack callBack) {
        String idfa = cidfa;
        String bundleid = pkg;
        String old_idfa = "";
        String userId = "";
        YFUser user = YFUserAgent.getCurrentUser();
        if (user != null) {
            if (!cidfa.equals(user.getIdfa())) {
                old_idfa = user.getIdfa();
            }
            userId = user.getUserid();
        }
        String last_userId = "";
        if (!TextUtils.isEmpty((CharSequence)old_userid)) {
            last_userId = old_userid;
        }
        STYPE sTypeName = sType;
        String sToken = "";
        if (!TextUtils.isEmpty((CharSequence)sAccount)) {
            sToken = sAccount;
        }
        int action = 10;
        if (user == null && !TextUtils.isEmpty((CharSequence)idfa) && (sType == null || TextUtils.isEmpty((CharSequence)sToken))) {
            action = 10;
        } else if (user == null && TextUtils.isEmpty((CharSequence)idfa) && (sType == null || TextUtils.isEmpty((CharSequence)sToken))) {
            action = 11;
        } else if (sType != null && !TextUtils.isEmpty((CharSequence)sToken) && (user == null || user != null && !sToken.equals(user.getSaccount()))) {
            action = 20;
        } else if (user != null) {
            if (DLog.isDebug()) {
                String userStr = user.toString();
                DLog.d((String)("[YiFans_YFUser] return cache user data ! " + userStr));
            }
            if (callBack != null) {
                callBack.onSuccess(user);
            }
            return;
        }
        HttpHelper.getUser(action, idfa, old_idfa, userId, last_userId, sTypeName, sToken, bundleid, callBack);
    }

    public static YFUser getCurrentUser() {
        return CacheHelper.getCurrentUser();
    }

    public static boolean logout() {
        return CacheHelper.clearCurrentUser();
    }

    public static String getPkg() {
        return pkg;
    }

    public static String getIdfa() {
        return cidfa;
    }

    static {
        cidfa = "";
    }
}

