/*
 * Decompiled with CFR 0.152.
 */
package com.fineboost.storage.data;

import android.text.TextUtils;
import com.common.utils.DLog;
import com.common.utils.http.Callback;
import com.common.utils.http.HttpUtils;
import com.common.utils.http.Request;
import com.common.utils.http.Response;
import com.fineboost.auth.YFAuthAgent;
import com.fineboost.auth.data.SignTools;
import com.fineboost.auth.data.YFUser;
import com.fineboost.storage.DeleteCallBack;
import com.fineboost.storage.QueryCallBack;
import com.fineboost.storage.SaveCallBack;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestHelper {
    private static final String SECRET = "8253acca655f04f7";
    private static final String HOST = "https://storage.fineboost.com/s";

    public static void query(String archiveTags, final QueryCallBack queryArchiveCallBack) {
        YFUser currentUser = YFAuthAgent.getAuthUser();
        if (currentUser == null) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_Storage] http query currentUser is null");
            }
            if (queryArchiveCallBack != null) {
                queryArchiveCallBack.onFailed("Failed, currentUser is null!");
            }
            return;
        }
        String requestContent = "";
        try {
            JSONObject requserBody = new JSONObject();
            requserBody.put("userid", (Object)currentUser.getUserid());
            requserBody.put("bundleid", (Object)YFAuthAgent.getPkg());
            requserBody.put("platform", (Object)"1");
            requserBody.put("archiveTags", (Object)archiveTags);
            requserBody.put("action", (Object)"0");
            requestContent = requserBody.toString();
        }
        catch (JSONException e) {
            DLog.e((Throwable)e);
            if (queryArchiveCallBack != null) {
                queryArchiveCallBack.onFailed("Failed, create requserBody error!");
            }
            return;
        }
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_Storage] http query requestContent=> " + requestContent));
        }
        String uuid = UUID.randomUUID().toString();
        String ts = String.valueOf(System.currentTimeMillis());
        String sign = SignTools.getSHA1((String)(requestContent + uuid + ts + SECRET));
        HashMap<String, String> headerParams = RequestHelper.createHeaderParams(uuid, ts, sign);
        HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DLog.isDebug()) {
                    DLog.e((Throwable)e);
                    DLog.e((String)("[YiFans_Storage] http query onFailure=> " + e.getLocalizedMessage()));
                }
                if (queryArchiveCallBack != null) {
                    queryArchiveCallBack.onFailed(e.getLocalizedMessage());
                }
            }

            public void onResponse(Response response) {
                block8: {
                    try {
                        JSONObject allResponse;
                        String responseContent = new String(response.responseContent, "utf-8");
                        if (DLog.isDebug()) {
                            DLog.d((String)("[YiFans_Storage] http query responseContent=> " + responseContent));
                        }
                        if ((allResponse = new JSONObject(responseContent)) != null) {
                            Iterator archiveTags = allResponse.keys();
                            HashMap<String, String> archiveContent = new HashMap<String, String>();
                            while (archiveTags.hasNext()) {
                                String key = (String)archiveTags.next();
                                String vaule = allResponse.optString(key);
                                if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)vaule)) continue;
                                archiveContent.put(key, vaule);
                            }
                            if (queryArchiveCallBack != null) {
                                queryArchiveCallBack.onQuerySuccess(archiveContent);
                            }
                        } else if (queryArchiveCallBack != null) {
                            queryArchiveCallBack.onFailed("Failed, response has no archives! ");
                        }
                    }
                    catch (Exception e) {
                        DLog.e((Throwable)e);
                        if (queryArchiveCallBack == null) break block8;
                        queryArchiveCallBack.onFailed(e.getLocalizedMessage());
                    }
                }
            }
        });
    }

    public static void save(Map<String, String> multiArchives, final SaveCallBack saveArchiveCallBack) {
        if (multiArchives == null || multiArchives.size() == 0) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_Storage] http save game archive is null!");
            }
            if (saveArchiveCallBack != null) {
                saveArchiveCallBack.onFailed("Failed, game archive is null!");
            }
            return;
        }
        YFUser currentUser = YFAuthAgent.getAuthUser();
        if (currentUser == null) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_Storage] http save currentUser is null");
            }
            if (saveArchiveCallBack != null) {
                saveArchiveCallBack.onFailed("Failed, currentUser is null!");
            }
            return;
        }
        String requestContent = "";
        try {
            JSONObject requserBody = new JSONObject();
            requserBody.put("archives", (Object)new JSONObject(multiArchives));
            requserBody.put("userid", (Object)currentUser.getUserid());
            requserBody.put("bundleid", (Object)YFAuthAgent.getPkg());
            requserBody.put("platform", (Object)"1");
            requserBody.put("action", (Object)"1");
            requestContent = requserBody.toString();
        }
        catch (JSONException e) {
            DLog.e((Throwable)e);
            if (saveArchiveCallBack != null) {
                saveArchiveCallBack.onFailed("Failed, create requserBody error!");
            }
            return;
        }
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_Storage] http save requestContent=> " + requestContent));
        }
        String uuid = UUID.randomUUID().toString();
        String ts = String.valueOf(System.currentTimeMillis());
        String sign = SignTools.getSHA1((String)(requestContent + uuid + ts + SECRET));
        HashMap<String, String> headerParams = RequestHelper.createHeaderParams(uuid, ts, sign);
        HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DLog.isDebug()) {
                    DLog.e((Throwable)e);
                    DLog.e((String)("[YiFans_Storage] http save onFailure=> " + e.getLocalizedMessage()));
                }
                if (saveArchiveCallBack != null) {
                    saveArchiveCallBack.onFailed(e.getLocalizedMessage());
                }
            }

            public void onResponse(Response response) {
                block4: {
                    try {
                        String responseContent = new String(response.responseContent, "utf-8");
                        if (DLog.isDebug()) {
                            DLog.d((String)("[YiFans_Storage] http save responseContent=> " + responseContent));
                        }
                        if (saveArchiveCallBack != null) {
                            saveArchiveCallBack.onSuccess();
                        }
                    }
                    catch (Exception e) {
                        DLog.e((Throwable)e);
                        if (saveArchiveCallBack == null) break block4;
                        saveArchiveCallBack.onFailed(e.getLocalizedMessage());
                    }
                }
            }
        });
    }

    public static void del(String archiveTags, final DeleteCallBack delArchiveCallBack) {
        YFUser currentUser = YFAuthAgent.getAuthUser();
        if (currentUser == null) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_Storage] http del currentUser is null");
            }
            if (delArchiveCallBack != null) {
                delArchiveCallBack.onFailed("Failed, currentUser is null!");
            }
            return;
        }
        String requestContent = "";
        try {
            JSONObject requserBody = new JSONObject();
            requserBody.put("userid", (Object)currentUser.getUserid());
            requserBody.put("bundleid", (Object)YFAuthAgent.getPkg());
            requserBody.put("platform", (Object)"1");
            requserBody.put("archiveTags", (Object)archiveTags);
            requserBody.put("action", (Object)"-1");
            requestContent = requserBody.toString();
        }
        catch (JSONException e) {
            DLog.e((Throwable)e);
            if (delArchiveCallBack != null) {
                delArchiveCallBack.onFailed("Failed, create requserBody error!");
            }
            return;
        }
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_Storage] http del requestContent=> " + requestContent));
        }
        String uuid = UUID.randomUUID().toString();
        String ts = String.valueOf(System.currentTimeMillis());
        String sign = SignTools.getSHA1((String)(requestContent + uuid + ts + SECRET));
        HashMap<String, String> headerParams = RequestHelper.createHeaderParams(uuid, ts, sign);
        HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DLog.isDebug()) {
                    DLog.e((Throwable)e);
                    DLog.e((String)("[YiFans_Storage] http del onFailure=> " + e.getLocalizedMessage()));
                }
                if (delArchiveCallBack != null) {
                    delArchiveCallBack.onFailed(e.getLocalizedMessage());
                }
            }

            public void onResponse(Response response) {
                block4: {
                    try {
                        String responseContent = new String(response.responseContent, "utf-8");
                        if (DLog.isDebug()) {
                            DLog.d((String)("[YiFans_Storage] http del responseContent=> " + responseContent));
                        }
                        if (delArchiveCallBack != null) {
                            delArchiveCallBack.onSuccess();
                        }
                    }
                    catch (Exception e) {
                        DLog.e((Throwable)e);
                        if (delArchiveCallBack == null) break block4;
                        delArchiveCallBack.onFailed(e.getLocalizedMessage());
                    }
                }
            }
        });
    }

    private static HashMap<String, String> createHeaderParams(String uuid, String ts, String sign) {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("X-Storage-Nonce", uuid);
        headerParams.put("X-Storage-TS", ts);
        headerParams.put("X-Storage-SN", sign);
        headerParams.put("X-Storage-Ver", "1.0");
        return headerParams;
    }
}

