/*
 * Decompiled with CFR 0.152.
 */
package com.fineboost.storage;

import android.content.Context;
import android.text.TextUtils;
import com.common.utils.DLog;
import com.fineboost.auth.LogoutListener;
import com.fineboost.auth.YFAuthAgent;
import com.fineboost.auth.data.YFUser;
import com.fineboost.storage.DeleteCallBack;
import com.fineboost.storage.QueryCallBack;
import com.fineboost.storage.SaveCallBack;
import com.fineboost.storage.data.RequestHelper;
import java.util.HashMap;

public class YFStorageAgent {
    private static LogoutListener logoutListener;
    private static HashMap<String, String> ready2Save;

    public static void onApploctionCreated(Context context) {
        YFAuthAgent.onApploctionCreated((Context)context);
        logoutListener = new LogoutListener(){

            public void onCompleted() {
                if (ready2Save != null) {
                    ready2Save.clear();
                }
            }
        };
        YFAuthAgent.addLogoutListener((LogoutListener)logoutListener);
    }

    public static boolean isAble() {
        YFUser user = YFAuthAgent.getAuthUser();
        return user != null && !TextUtils.isEmpty((CharSequence)user.getUserid());
    }

    public static void set(String key, String vaule) {
        if (ready2Save == null) {
            ready2Save = new HashMap();
        }
        ready2Save.put(key, vaule);
        if (DLog.isDebug()) {
            DLog.d((String)("YiFans_Storage_[set] key: " + key + " - vaule: " + vaule));
        }
    }

    public static void save(SaveCallBack callBack) {
        if (!YFStorageAgent.isAble()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_Storage_[save] Failed, current user is null, can not do save!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_Storage_[save] Failed, current user is null, can not save!");
            }
            return;
        }
        if (ready2Save != null) {
            RequestHelper.save(ready2Save, callBack);
        } else {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_Storage_[save] Failed, has no data to save, please set the data!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_Storage_[save] Failed, has no data to save, please set the data!");
            }
        }
    }

    public static void query(String keys, QueryCallBack callBack) {
        if (!YFStorageAgent.isAble()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_Storage_[query] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_Storage_[query] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        RequestHelper.query(keys, callBack);
    }

    public static void queryAll(QueryCallBack callBack) {
        if (!YFStorageAgent.isAble()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_Storage_[queryAll] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_Storage_[queryAll] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        YFStorageAgent.query("", callBack);
    }

    public static void delete(String keys, DeleteCallBack callBack) {
        if (!YFStorageAgent.isAble()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_Storage_[delete] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_Storage_[delete] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        RequestHelper.del(keys, callBack);
    }

    public static void deleteAll(DeleteCallBack callBack) {
        if (!YFStorageAgent.isAble()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_Storage_[deleteAll] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_Storage_[deleteAll] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        RequestHelper.del("", callBack);
    }

    public static String getVersion() {
        return "1.0.1";
    }

    static {
        ready2Save = new HashMap();
    }
}

