/*
 * Decompiled with CFR 0.152.
 */
package com.fineboost.storage;

import android.text.TextUtils;
import com.common.utils.DLog;
import com.fineboost.auth.YFUserAgent;
import com.fineboost.auth.data.YFUser;
import com.fineboost.storage.DelArchiveCallBack;
import com.fineboost.storage.QueryArchiveCallBack;
import com.fineboost.storage.SaveArchiveCallBack;
import com.fineboost.storage.data.HttpHelper;
import java.util.HashMap;
import java.util.Map;

public class GameArchiveAgent {
    public static boolean canDoGameArchive() {
        YFUser user = YFUserAgent.getCurrentUser();
        return user != null && !TextUtils.isEmpty((CharSequence)user.getUserid());
    }

    public static void querySingleArchive(QueryArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[querySingleArchive] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[querySingleArchive] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        GameArchiveAgent.queryXXArchive("_SingleArchive_", callBack);
    }

    public static void queryXXArchive(String archiveTags, QueryArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[queryXXArchive] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[queryXXArchive] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        HttpHelper.query(archiveTags, callBack);
    }

    public static void queryAllArchive(QueryArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[queryAllArchive] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[queryAllArchive] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        GameArchiveAgent.queryXXArchive("", callBack);
    }

    public static void saveSingleArchive(String archiveStr, SaveArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[saveSingleArchive] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[saveSingleArchive] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        HashMap<String, String> archiveMap = new HashMap<String, String>(1);
        archiveMap.put("_SingleArchive_", archiveStr);
        GameArchiveAgent.saveXXArchive(archiveMap, callBack);
    }

    public static void saveXXArchive(Map<String, String> multiArchives, SaveArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[saveXXArchive] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[saveXXArchive] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        HttpHelper.save(multiArchives, callBack);
    }

    public static void delSingleArchive(DelArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[delSingleArchive] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[delSingleArchive] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        GameArchiveAgent.delXXArchive("_SingleArchive_", callBack);
    }

    public static void delXXArchive(String archiveTags, DelArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[delXXArchive] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[delXXArchive] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        HttpHelper.del(archiveTags, callBack);
    }

    public static void delAllArchives(DelArchiveCallBack callBack) {
        if (!GameArchiveAgent.canDoGameArchive()) {
            if (DLog.isDebug()) {
                DLog.e((String)"YiFans_GameArchive_[delAllArchives] Failed, current user is null, can not do GameArchive!");
            }
            if (callBack != null) {
                callBack.onFailed("YiFans_GameArchive_[delAllArchives] Failed, current user is null, can not do GameArchive!");
            }
            return;
        }
        HttpHelper.del("", callBack);
    }
}

