/*
 * Decompiled with CFR 0.152.
 */
package com.yifans.sdk.archive.data;

import android.text.TextUtils;
import com.common.utils.DLog;
import com.common.utils.http.Callback;
import com.common.utils.http.HttpUtils;
import com.common.utils.http.Request;
import com.common.utils.http.Response;
import com.yifans.sdk.archive.DelArchiveCallBack;
import com.yifans.sdk.archive.QueryArchiveCallBack;
import com.yifans.sdk.archive.SaveArchiveCallBack;
import com.yifans.sdk.users.YFUserAgent;
import com.yifans.sdk.users.data.SignTools;
import com.yifans.sdk.users.data.YFUser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpHelper {
    public static final String SINGLE_ARCHIVE = "_SingleArchive_";
    private static final String SECRET = "8253acca655f04f7";
    private static final String HOST = "http://192.168.1.10:31313/storage";

    public static void query(String archiveTags, final QueryArchiveCallBack queryArchiveCallBack) {
        YFUser currentUser = YFUserAgent.getCurrentUser();
        if (currentUser == null) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_GameArchive] http query currentUser is null");
            }
            if (queryArchiveCallBack != null) {
                queryArchiveCallBack.onFailed("Failed, currentUser is null!");
            }
            return;
        }
        String requestContent = "";
        try {
            JSONObject requserBody = new JSONObject();
            requserBody.put("userid", (Object)currentUser.getUserid());
            requserBody.put("bundleid", (Object)YFUserAgent.getPkg());
            requserBody.put("platform", (Object)"1");
            requserBody.put("archiveTags", (Object)archiveTags);
            requserBody.put("action", (Object)"0");
            requestContent = requserBody.toString();
        }
        catch (JSONException e) {
            DLog.e((Throwable)e);
            if (queryArchiveCallBack != null) {
                queryArchiveCallBack.onFailed("Failed, create requserBody error!");
            }
            return;
        }
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_GameArchive] http query requestContent=> " + requestContent));
        }
        String uuid = UUID.randomUUID().toString();
        String ts = String.valueOf(System.currentTimeMillis());
        String sign = SignTools.getSHA1((String)(requestContent + uuid + ts + SECRET));
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_GameArchive] http query uuid=> " + uuid + "; ts=> " + ts + "; sign=> " + sign));
        }
        HashMap<String, String> headerParams = HttpHelper.createHeaderParams(uuid, ts, sign);
        HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DLog.isDebug()) {
                    DLog.e((Throwable)e);
                    DLog.e((String)("[YiFans_GameArchive] http query onFailure=> " + e.getLocalizedMessage()));
                }
                if (queryArchiveCallBack != null) {
                    queryArchiveCallBack.onFailed(e.getLocalizedMessage());
                }
            }

            public void onResponse(Response response) {
                block10: {
                    try {
                        JSONObject allResponse;
                        String responseContent = new String(response.responseContent, "utf-8");
                        if (DLog.isDebug()) {
                            DLog.d((String)("[YiFans_GameArchive] http query responseContent=> " + responseContent));
                        }
                        if ((allResponse = new JSONObject(responseContent)) != null) {
                            Iterator archiveTags = allResponse.keys();
                            HashMap<String, String> archiveContent = new HashMap<String, String>();
                            while (archiveTags.hasNext()) {
                                String archiveTag = (String)archiveTags.next();
                                String archiveStr = allResponse.optString(archiveTag);
                                if (TextUtils.isEmpty((CharSequence)archiveStr) || TextUtils.isEmpty((CharSequence)archiveStr)) continue;
                                archiveContent.put(archiveTag, archiveStr);
                            }
                            if (queryArchiveCallBack != null) {
                                if (archiveContent.size() == 1 && archiveContent.containsKey(HttpHelper.SINGLE_ARCHIVE)) {
                                    queryArchiveCallBack.onSingleArchiveFound((String)archiveContent.get(HttpHelper.SINGLE_ARCHIVE));
                                } else {
                                    queryArchiveCallBack.onXXArchiveFound(archiveContent);
                                }
                            }
                        } else if (queryArchiveCallBack != null) {
                            queryArchiveCallBack.onFailed("Failed, response has no archives! ");
                        }
                    }
                    catch (Exception e) {
                        DLog.e((Throwable)e);
                        if (queryArchiveCallBack == null) break block10;
                        queryArchiveCallBack.onFailed(e.getLocalizedMessage());
                    }
                }
            }
        });
    }

    public static void save(Map<String, String> multiArchives, final SaveArchiveCallBack saveArchiveCallBack) {
        if (multiArchives == null || multiArchives.size() == 0) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_GameArchive] http save game archive is null!");
            }
            if (saveArchiveCallBack != null) {
                saveArchiveCallBack.onFailed("Failed, game archive is null!");
            }
            return;
        }
        YFUser currentUser = YFUserAgent.getCurrentUser();
        if (currentUser == null) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_GameArchive] http save currentUser is null");
            }
            if (saveArchiveCallBack != null) {
                saveArchiveCallBack.onFailed("Failed, currentUser is null!");
            }
            return;
        }
        String requestContent = "";
        try {
            JSONObject requserBody = new JSONObject();
            requserBody.put("archives", (Object)new JSONObject(multiArchives));
            requserBody.put("userid", (Object)currentUser.getUserid());
            requserBody.put("bundleid", (Object)YFUserAgent.getPkg());
            requserBody.put("platform", (Object)"1");
            requserBody.put("action", (Object)"1");
            requestContent = requserBody.toString();
        }
        catch (JSONException e) {
            DLog.e((Throwable)e);
            if (saveArchiveCallBack != null) {
                saveArchiveCallBack.onFailed("Failed, create requserBody error!");
            }
            return;
        }
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_GameArchive] http save requestContent=> " + requestContent));
        }
        String uuid = UUID.randomUUID().toString();
        String ts = String.valueOf(System.currentTimeMillis());
        String sign = SignTools.getSHA1((String)(requestContent + uuid + ts + SECRET));
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_GameArchive] http save uuid=> " + uuid + "; ts=> " + ts + "; sign=> " + sign));
        }
        HashMap<String, String> headerParams = HttpHelper.createHeaderParams(uuid, ts, sign);
        HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DLog.isDebug()) {
                    DLog.e((Throwable)e);
                    DLog.e((String)("[YiFans_GameArchive] http save onFailure=> " + e.getLocalizedMessage()));
                }
                if (saveArchiveCallBack != null) {
                    saveArchiveCallBack.onFailed(e.getLocalizedMessage());
                }
            }

            public void onResponse(Response response) {
                block4: {
                    try {
                        String responseContent = new String(response.responseContent, "utf-8");
                        if (DLog.isDebug()) {
                            DLog.d((String)("[YiFans_GameArchive] http save responseContent=> " + responseContent));
                        }
                        if (saveArchiveCallBack != null) {
                            saveArchiveCallBack.onSuccess();
                        }
                    }
                    catch (Exception e) {
                        DLog.e((Throwable)e);
                        if (saveArchiveCallBack == null) break block4;
                        saveArchiveCallBack.onFailed(e.getLocalizedMessage());
                    }
                }
            }
        });
    }

    public static void del(String archiveTags, final DelArchiveCallBack delArchiveCallBack) {
        YFUser currentUser = YFUserAgent.getCurrentUser();
        if (currentUser == null) {
            if (DLog.isDebug()) {
                DLog.e((String)"[YiFans_GameArchive] http del currentUser is null");
            }
            if (delArchiveCallBack != null) {
                delArchiveCallBack.onFailed("Failed, currentUser is null!");
            }
            return;
        }
        String requestContent = "";
        try {
            JSONObject requserBody = new JSONObject();
            requserBody.put("userid", (Object)currentUser.getUserid());
            requserBody.put("bundleid", (Object)YFUserAgent.getPkg());
            requserBody.put("platform", (Object)"1");
            requserBody.put("archiveTags", (Object)archiveTags);
            requserBody.put("action", (Object)"-1");
            requestContent = requserBody.toString();
        }
        catch (JSONException e) {
            DLog.e((Throwable)e);
            if (delArchiveCallBack != null) {
                delArchiveCallBack.onFailed("Failed, create requserBody error!");
            }
            return;
        }
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_GameArchive] http del requestContent=> " + requestContent));
        }
        String uuid = UUID.randomUUID().toString();
        String ts = String.valueOf(System.currentTimeMillis());
        String sign = SignTools.getSHA1((String)(requestContent + uuid + ts + SECRET));
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_GameArchive] http del uuid=> " + uuid + "; ts=> " + ts + "; sign=> " + sign));
        }
        HashMap<String, String> headerParams = HttpHelper.createHeaderParams(uuid, ts, sign);
        HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DLog.isDebug()) {
                    DLog.e((Throwable)e);
                    DLog.e((String)("[YiFans_GameArchive] http del onFailure=> " + e.getLocalizedMessage()));
                }
                if (delArchiveCallBack != null) {
                    delArchiveCallBack.onFailed(e.getLocalizedMessage());
                }
            }

            public void onResponse(Response response) {
                block4: {
                    try {
                        String responseContent = new String(response.responseContent, "utf-8");
                        if (DLog.isDebug()) {
                            DLog.d((String)("[YiFans_GameArchive] http del responseContent=> " + responseContent));
                        }
                        if (delArchiveCallBack != null) {
                            delArchiveCallBack.onSuccess();
                        }
                    }
                    catch (Exception e) {
                        DLog.e((Throwable)e);
                        if (delArchiveCallBack == null) break block4;
                        delArchiveCallBack.onFailed(e.getLocalizedMessage());
                    }
                }
            }
        });
    }

    private static HashMap<String, String> createHeaderParams(String uuid, String ts, String sign) {
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("X-Storage-Nonce", uuid);
        headerParams.put("X-Storage-TS", ts);
        headerParams.put("X-Storage-SN", sign);
        headerParams.put("X-Storage-Ver", "1.0");
        return headerParams;
    }
}

