/*
 * Decompiled with CFR 0.152.
 */
package com.fineboost.t.task;

import com.common.utils.DLog;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class BaseTaskServices {
    protected ScheduledExecutorService mExecutorService;

    protected BaseTaskServices(int n) {
        this.mExecutorService = n == 1 ? Executors.newSingleThreadScheduledExecutor() : Executors.newScheduledThreadPool(n);
    }

    public void submitTask(Runnable runnable) {
        try {
            this.mExecutorService.submit(runnable);
        }
        catch (Exception exception) {
            DLog.e((Throwable)exception);
        }
    }

    public ScheduledFuture scheduleTask(Runnable runnable, long l) {
        try {
            return this.mExecutorService.schedule(runnable, l, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            DLog.e((Throwable)exception);
            return null;
        }
    }

    public ScheduledFuture scheduleAtFixedRate(Runnable runnable, long l, long l2) {
        try {
            return this.mExecutorService.scheduleAtFixedRate(runnable, l, l2, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            DLog.e((Throwable)exception);
            return null;
        }
    }

    public ScheduledFuture scheduleWithFixedDelay(Runnable runnable, long l, long l2) {
        try {
            return this.mExecutorService.scheduleWithFixedDelay(runnable, l, l2, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            DLog.e((Throwable)exception);
            return null;
        }
    }
}

