/*
 * Decompiled with CFR 0.152.
 */
package com.fineboost.t;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.common.utils.DLog;
import java.util.ArrayList;

public class ForeBackManager {
    private final ArrayList<ToBackgroundObserver> mBackgroundObservers;
    private final ArrayList<ToForegroundObserver> mForegroundObservers;
    private int aliveNum = 0;
    private int aliveState = 0;
    private boolean isLaucher = true;
    long toForeground = System.currentTimeMillis();

    private ForeBackManager() {
        this.mBackgroundObservers = new ArrayList();
        this.mForegroundObservers = new ArrayList();
    }

    public static ForeBackManager getInstance() {
        return a.a;
    }

    public void createInAppliction(Application application) {
        if (DLog.isDebug()) {
            DLog.d((String)"ForeBackground [- createInAppliction -]");
        }
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
            }

            public void onActivityStarted(Activity activity) {
                ForeBackManager.this.aliveNum++;
                if (ForeBackManager.this.aliveNum == 1) {
                    ForeBackManager.this.aliveState = 1;
                    if (!ForeBackManager.this.isLaucher) {
                        ForeBackManager.this.dispatchToForegroundEvent();
                    }
                    ForeBackManager.this.isLaucher = false;
                } else {
                    ForeBackManager.this.aliveState = 2;
                }
            }

            public void onActivityResumed(Activity activity) {
                ForeBackManager.this.toForeground = System.currentTimeMillis();
                if (DLog.isDebug()) {
                    DLog.d((String)("Auth ForeBackground - onActivityResumed: - resumed -" + System.currentTimeMillis()));
                }
            }

            public void onActivityPaused(Activity activity) {
                if (DLog.isDebug()) {
                    DLog.d((String)("Auth ForeBackground - onActivityPaused: - paused -" + System.currentTimeMillis()));
                }
            }

            public void onActivityStopped(Activity activity) {
                ForeBackManager.this.aliveNum--;
                if (ForeBackManager.this.aliveNum == 0) {
                    ForeBackManager.this.aliveState = 0;
                    ForeBackManager.this.dispatchToBackgroundEvent();
                }
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }
        });
    }

    public boolean isBackground() {
        return this.aliveState == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeBackManager registerBackgroundObserver(ToBackgroundObserver toBackgroundObserver) {
        ArrayList<ToBackgroundObserver> arrayList = this.mBackgroundObservers;
        synchronized (arrayList) {
            this.mBackgroundObservers.add(toBackgroundObserver);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeBackManager unregisterBackgroundObserver(ToBackgroundObserver toBackgroundObserver) {
        ArrayList<ToBackgroundObserver> arrayList = this.mBackgroundObservers;
        synchronized (arrayList) {
            this.mBackgroundObservers.remove(toBackgroundObserver);
        }
        return this;
    }

    private void dispatchToBackgroundEvent() {
        if (DLog.isDebug()) {
            DLog.d((String)"Auth ForeBackground [foreToBackground] ");
        }
        for (ToBackgroundObserver toBackgroundObserver : this.mBackgroundObservers) {
            toBackgroundObserver.foreToBackground();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeBackManager registerForegroundObserver(ToForegroundObserver toForegroundObserver) {
        ArrayList<ToForegroundObserver> arrayList = this.mForegroundObservers;
        synchronized (arrayList) {
            this.mForegroundObservers.add(toForegroundObserver);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeBackManager unregisterForegroundObserver(ToForegroundObserver toForegroundObserver) {
        ArrayList<ToForegroundObserver> arrayList = this.mForegroundObservers;
        synchronized (arrayList) {
            this.mForegroundObservers.remove(toForegroundObserver);
        }
        return this;
    }

    private void dispatchToForegroundEvent() {
        if (DLog.isDebug()) {
            DLog.d((String)"Auth ForeBackground [backToForeground] ");
        }
        for (ToForegroundObserver toForegroundObserver : this.mForegroundObservers) {
            toForegroundObserver.backToForeground();
        }
    }

    public static interface ToForegroundObserver {
        public void backToForeground();
    }

    public static interface ToBackgroundObserver {
        public void foreToBackground();
    }

    static class a {
        static ForeBackManager a = new ForeBackManager();
    }
}

