/*
 * Decompiled with CFR 0.152.
 */
package com.fineboost.auth;

import android.content.Context;
import android.text.TextUtils;
import com.common.utils.DLog;
import com.common.utils.PlayServicesUtils;
import com.fineboost.auth.AuthCallBack;
import com.fineboost.auth.STYPE;
import com.fineboost.auth.data.CacheHelper;
import com.fineboost.auth.data.RequestHelper;
import com.fineboost.auth.data.YFUser;

public class YFAuthAgent {
    private static String pkg;
    private static String cidfa;

    public static void onApploctionCreated(Context context) {
        pkg = context.getPackageName();
        CacheHelper.init(context);
        PlayServicesUtils.getPlayAdId((Context)context, (PlayServicesUtils.PlayAdIdReadListener)new PlayServicesUtils.PlayAdIdReadListener(){

            public void onPlayAdIdRead(String playAdId) {
                if (!TextUtils.isEmpty((CharSequence)playAdId)) {
                    cidfa = playAdId;
                }
                if (DLog.isDebug()) {
                    DLog.d((String)("[YiFans_YFAuth] onApploctionCreated idfa=> " + cidfa));
                }
                RequestHelper.noticeUserAlive();
            }
        });
    }

    public static void checkAuth(String userid, AuthCallBack callBack) {
        YFAuthAgent.auth(userid, null, null, callBack);
    }

    public static void queryByIdfa(AuthCallBack callBack) {
        YFAuthAgent.queryBySocial(STYPE.IDFA, cidfa, callBack);
    }

    public static void queryBySocial(STYPE sType, String sAccount, AuthCallBack callBack) {
        if (TextUtils.isEmpty((CharSequence)cidfa)) {
            DLog.e((String)"YiFans_Auth_[queryByXXX] idfa is null!");
            if (callBack != null) {
                callBack.onFailed(410, "");
            }
            return;
        }
        RequestHelper.auth(21, cidfa, "", "", sType, sAccount, pkg, callBack);
    }

    public static YFUser getAuthUser() {
        return CacheHelper.getCurrentUser();
    }

    public static void authVisitor(AuthCallBack callBack) {
        YFAuthAgent.auth(null, null, null, callBack);
    }

    public static void authIdfa(final AuthCallBack callBack) {
        if (TextUtils.isEmpty((CharSequence)cidfa)) {
            DLog.e((String)"YiFans_Auth_[authIdfa] idfa is null!");
            if (callBack != null) {
                callBack.onFailed(410, "idfa is null!");
            }
            return;
        }
        YFUser user = YFAuthAgent.getAuthUser();
        if (user == null || TextUtils.isEmpty((CharSequence)user.getUserid())) {
            DLog.e((String)"YiFans_Auth_[authIdfa] userid is null, auto auth first !");
            YFAuthAgent.authVisitor(new AuthCallBack(){

                @Override
                public void onSuccess(YFUser user) {
                    YFAuthAgent.auth(null, STYPE.IDFA, cidfa, callBack);
                }

                @Override
                public void onFailed(int code, String msg) {
                    DLog.e((String)"YiFans_Auth_[authIdfa] userid is null, auto auth first => end onFailed!");
                    if (callBack != null) {
                        callBack.onFailed(409, "userid is null, auto auth first => end onFailed!");
                    }
                }
            });
        } else {
            YFAuthAgent.auth(null, STYPE.IDFA, cidfa, callBack);
        }
    }

    public static void authSocialAccount(final STYPE sType, final String sAccount, final AuthCallBack callBack) {
        YFUser user = YFAuthAgent.getAuthUser();
        if (user == null || TextUtils.isEmpty((CharSequence)user.getUserid())) {
            DLog.e((String)"YiFans_Auth_[authSocialAccount] userid is null, auto auth first !");
            YFAuthAgent.authVisitor(new AuthCallBack(){

                @Override
                public void onSuccess(YFUser user) {
                    YFAuthAgent.auth(null, sType, sAccount, callBack);
                }

                @Override
                public void onFailed(int code, String msg) {
                    DLog.e((String)"YiFans_Auth_[authSocialAccount] userid is null, auto auth first => end onFailed!");
                    if (callBack != null) {
                        callBack.onFailed(409, "userid is null, auto auth first => end onFailed!");
                    }
                }
            });
        } else {
            YFAuthAgent.auth(null, sType, sAccount, callBack);
        }
    }

    private static void auth(String old_userid, STYPE sType, String sAccount, AuthCallBack callBack) {
        String idfa = cidfa;
        String bundleid = pkg;
        String userId = "";
        YFUser user = YFAuthAgent.getAuthUser();
        if (user != null) {
            userId = user.getUserid();
        }
        String check_userId = "";
        if (!TextUtils.isEmpty((CharSequence)old_userid)) {
            check_userId = old_userid;
        }
        STYPE sTypeName = sType;
        String sToken = "";
        if (!TextUtils.isEmpty((CharSequence)sAccount)) {
            sToken = sAccount;
        }
        int action = 10;
        if (!TextUtils.isEmpty((CharSequence)check_userId)) {
            action = 30;
        } else if (user == null && !TextUtils.isEmpty((CharSequence)idfa) && (sType == null || TextUtils.isEmpty((CharSequence)sToken))) {
            action = 10;
        } else if (user == null && TextUtils.isEmpty((CharSequence)idfa) && (sType == null || TextUtils.isEmpty((CharSequence)sToken))) {
            action = 11;
        } else if (sType != null && !TextUtils.isEmpty((CharSequence)sToken) && (user == null || user != null && !sToken.equals(user.getSaccount()))) {
            action = 20;
        } else if (user != null) {
            if (DLog.isDebug()) {
                String userStr = user.toString();
                DLog.d((String)("[YiFans_Auth] return cache user data ! " + userStr));
            }
            if (callBack != null) {
                callBack.onSuccess(user);
            }
            return;
        }
        RequestHelper.auth(action, idfa, userId, check_userId, sTypeName, sToken, bundleid, callBack);
    }

    public static boolean logout() {
        return CacheHelper.clearCurrentUser();
    }

    public static String getPkg() {
        return pkg;
    }

    public static String getIdfa() {
        return cidfa;
    }

    public static String getVersion() {
        return "1.0.0";
    }

    static {
        cidfa = "";
    }
}

