/*
 * Decompiled with CFR 0.152.
 */
package com.fineboost.auth.data;

import android.text.TextUtils;
import com.common.utils.DLog;
import com.common.utils.http.Callback;
import com.common.utils.http.HttpUtils;
import com.common.utils.http.Request;
import com.common.utils.http.Response;
import com.fineboost.auth.AuthCallBack;
import com.fineboost.auth.STYPE;
import com.fineboost.auth.data.CacheHelper;
import com.fineboost.auth.data.SignTools;
import com.fineboost.auth.data.YFUser;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestHelper {
    private static final String HOST = "http://192.168.1.10:21212/auth";
    private static final String SECRET = "6051cdeae1ad0286";
    public static final int ACTION_LOGIN = 10;
    public static final int ACTION_LOGIN_NO_IDFA = 11;
    public static final int ACTION_BIND_XXX = 20;
    public static final int ACTION_QUERY_BY_XXX = 21;
    public static final int ACTION_CHECK_AUTH = 30;
    public static final int ACTION_NOTICE_ALIVE = 50;

    public static void auth(final int action, final String idfa, final String userid, final String check_userid, final STYPE sTypeName, final String saccount, final String bundleid, final AuthCallBack callBack) {
        String stype = "";
        if (sTypeName != null) {
            stype = sTypeName.getName();
        }
        String requestContent = RequestHelper.createRequest(action, idfa, userid, check_userid, stype, saccount, bundleid);
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_YFAuth] auth requestContet=> " + requestContent));
        }
        String uuid = UUID.randomUUID().toString();
        String ts = String.valueOf(System.currentTimeMillis());
        String sign = SignTools.getSHA1(requestContent + uuid + ts + SECRET);
        if (DLog.isDebug()) {
            DLog.d((String)("[YiFans_YFAuth] auth uuid=> " + uuid + "; ts=> " + ts + "; sign=> " + sign));
        }
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("X-User-Nonce", uuid);
        headerParams.put("X-User-TS", ts);
        headerParams.put("X-User-SN", sign);
        headerParams.put("X-User-Ver", "1.0");
        HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

            public void onFailure(Request request, IOException e) {
                if (DLog.isDebug()) {
                    DLog.d((String)("[YiFans_YFAuth] auth onFailure=> " + e.getLocalizedMessage()));
                }
                if (callBack != null) {
                    callBack.onFailed(400, e.getLocalizedMessage());
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Response response) {
                try {
                    String responseContent = new String(response.responseContent, "utf-8");
                    if (DLog.isDebug()) {
                        DLog.d((String)("[YiFans_YFAuth] auth responseContent=> " + responseContent));
                    }
                    YFUser user = new YFUser();
                    if (action == 30) {
                        if (!"1".equals(responseContent)) {
                            if (callBack == null) return;
                            callBack.onFailed(406, "checkLogin is failed, the userid is illegal!");
                            return;
                        }
                        user.setUserid(check_userid);
                    } else if (action == 21) {
                        if (TextUtils.isEmpty((CharSequence)responseContent)) {
                            if (callBack == null) return;
                            callBack.onFailed(406, "query is failed, No user has been bound!");
                            return;
                        }
                        user.setUserid(responseContent);
                    } else {
                        String rUserId = responseContent;
                        if (TextUtils.isEmpty((CharSequence)rUserId)) {
                            user.setUserid(userid);
                        } else {
                            user.setUserid(rUserId);
                        }
                    }
                    user.setIdfa(idfa);
                    user.setStype(sTypeName);
                    user.setSaccount(saccount);
                    user.setBundleid(bundleid);
                    user.setLastAliveTime();
                    CacheHelper.saveCurrentUser(user);
                    if (callBack == null) return;
                    callBack.onSuccess(user);
                    return;
                }
                catch (Exception e) {
                    DLog.e((Throwable)e);
                    if (callBack == null) return;
                    callBack.onFailed(401, e.getLocalizedMessage());
                }
            }
        });
    }

    private static String createRequest(int action, String idfa, String userid, String check_userid, String stype, String saccount, String bundleid) {
        try {
            JSONObject requestJO = new JSONObject();
            requestJO.put("action", (Object)String.valueOf(action));
            requestJO.put("idfa", (Object)idfa);
            requestJO.put("bundleid", (Object)bundleid);
            requestJO.put("platform", (Object)"1");
            if (action == 20 || action == 50) {
                requestJO.put("userid", (Object)userid);
                requestJO.put("stype", (Object)stype);
                requestJO.put("saccount", (Object)saccount);
            }
            if (action == 30) {
                requestJO.put("check_userid", (Object)check_userid);
            }
            if (action == 21) {
                requestJO.put("stype", (Object)stype);
                requestJO.put("saccount", (Object)saccount);
            }
            return requestJO.toString();
        }
        catch (JSONException e) {
            DLog.e((Throwable)e);
            return "";
        }
    }

    public static void noticeUserAlive() {
        final YFUser user = CacheHelper.getCurrentUser();
        if (user != null && !TextUtils.isEmpty((CharSequence)user.getUserid()) && user.needUpdateAliveTime()) {
            String stype = user.getStype() != null ? user.getStype().getName() : "";
            String requestContent = RequestHelper.createRequest(50, user.getIdfa(), user.getUserid(), "", stype, user.getSaccount(), user.getBundleid());
            if (DLog.isDebug()) {
                DLog.d((String)("[YiFans_YFAuth] noticeUserAlive requestContet=> " + requestContent));
            }
            String uuid = UUID.randomUUID().toString();
            String ts = String.valueOf(System.currentTimeMillis());
            String sign = SignTools.getSHA1(requestContent + uuid + ts + SECRET);
            if (DLog.isDebug()) {
                DLog.d((String)("[YiFans_YFAuth] noticeUserAlive uuid=> " + uuid + "; ts=> " + ts + "; sign=> " + sign));
            }
            HashMap<String, String> headerParams = new HashMap<String, String>();
            headerParams.put("X-User-Nonce", uuid);
            headerParams.put("X-User-TS", ts);
            headerParams.put("X-User-SN", sign);
            headerParams.put("X-User-Ver", "1.0");
            HttpUtils.post((String)HOST, headerParams, (String)requestContent, (Callback)new Callback(){

                public void onFailure(Request request, IOException e) {
                    if (DLog.isDebug()) {
                        DLog.d((String)("[YiFans_YFAuth] noticeUserAlive onFailure=> " + e.getLocalizedMessage()));
                    }
                }

                public void onResponse(Response response) {
                    try {
                        String responseContent = new String(response.responseContent, "utf-8");
                        if (DLog.isDebug()) {
                            DLog.d((String)("[YiFans_YFAuth] noticeUserAlive responseContent=> " + responseContent));
                        }
                        if (user != null) {
                            user.setLastAliveTime();
                            CacheHelper.saveCurrentUser(user);
                        }
                    }
                    catch (Exception e) {
                        DLog.e((Throwable)e);
                    }
                }
            });
        } else if (DLog.isDebug()) {
            DLog.d((String)"[YiFans_YFAuth] noticeUserAlive, not need notice rmote to update!");
        }
    }

    private static String getUrlConfig(int action, String idfa, String old_idfa, String userid, String old_userid, String stype, String saccount, String bundleid) {
        StringBuilder urlBuilder = new StringBuilder("http://192.168.1.10:21212/auth?action=" + action + "&idfa=" + idfa + "&bundleid=" + bundleid + "&platform=1");
        if (action == 20) {
            urlBuilder.append("&userid=" + userid);
            urlBuilder.append("&stype=" + stype);
            urlBuilder.append("&saccount=" + saccount);
        }
        return urlBuilder.toString();
    }

    private static String getSign(int action, String idfa, String uuid, String userid, String ts, String stype, String saccount, String bundleid) {
        String content = action + bundleid + idfa + uuid + "1" + saccount + stype + ts + userid + SECRET;
        return SignTools.getSHA1(content);
    }
}

